/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.KvState;
import org.apache.flink.runtime.state.KvStateSnapshot;

public class GenericListState<K, N, T, Backend extends AbstractStateBackend, W extends ValueState<ArrayList<T>> & KvState<K, N, ValueState<ArrayList<T>>, ValueStateDescriptor<ArrayList<T>>, Backend>>
implements ListState<T>,
KvState<K, N, ListState<T>, ListStateDescriptor<T>, Backend> {
    private final W wrappedState;

    public GenericListState(ValueState<ArrayList<T>> wrappedState) {
        if (!(wrappedState instanceof KvState)) {
            throw new IllegalArgumentException("Wrapped state must be a KvState.");
        }
        this.wrappedState = wrappedState;
    }

    @Override
    public void setCurrentKey(K key) {
        ((KvState)this.wrappedState).setCurrentKey(key);
    }

    @Override
    public void setCurrentNamespace(N namespace) {
        ((KvState)this.wrappedState).setCurrentNamespace(namespace);
    }

    @Override
    public KvStateSnapshot<K, N, ListState<T>, ListStateDescriptor<T>, Backend> snapshot(long checkpointId, long timestamp) throws Exception {
        KvStateSnapshot wrappedSnapshot = ((KvState)this.wrappedState).snapshot(checkpointId, timestamp);
        return new Snapshot(wrappedSnapshot);
    }

    @Override
    public void dispose() {
        ((KvState)this.wrappedState).dispose();
    }

    public Iterable<T> get() throws Exception {
        ArrayList result = (ArrayList)this.wrappedState.value();
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void add(T value) throws Exception {
        ArrayList<T> currentValue = (ArrayList<T>)this.wrappedState.value();
        if (currentValue == null) {
            currentValue = new ArrayList<T>();
            currentValue.add(value);
            this.wrappedState.update(currentValue);
        } else {
            currentValue.add(value);
            this.wrappedState.update(currentValue);
        }
    }

    public void clear() {
        this.wrappedState.clear();
    }

    private static class Snapshot<K, N, T, Backend extends AbstractStateBackend>
    implements KvStateSnapshot<K, N, ListState<T>, ListStateDescriptor<T>, Backend> {
        private static final long serialVersionUID = 1L;
        private final KvStateSnapshot<K, N, ValueState<ArrayList<T>>, ValueStateDescriptor<ArrayList<T>>, Backend> wrappedSnapshot;

        public Snapshot(KvStateSnapshot<K, N, ValueState<ArrayList<T>>, ValueStateDescriptor<ArrayList<T>>, Backend> wrappedSnapshot) {
            this.wrappedSnapshot = wrappedSnapshot;
        }

        @Override
        public KvState<K, N, ListState<T>, ListStateDescriptor<T>, Backend> restoreState(Backend stateBackend, TypeSerializer<K> keySerializer, ClassLoader classLoader, long recoveryTimestamp) throws Exception {
            return new GenericListState((ValueState)this.wrappedSnapshot.restoreState(stateBackend, keySerializer, classLoader, recoveryTimestamp));
        }

        @Override
        public void discardState() throws Exception {
            this.wrappedSnapshot.discardState();
        }

        @Override
        public long getStateSize() throws Exception {
            return this.wrappedSnapshot.getStateSize();
        }
    }
}

