/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.io.FileOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.akka.AkkaUtils$;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.apache.flink.runtime.jobmanager.JobManager$;
import org.apache.flink.runtime.jobmanager.MemoryArchivist;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.messages.JobManagerMessages$RequestRunningJobsStatus$;
import org.apache.flink.runtime.minicluster.FlinkMiniCluster;
import org.apache.flink.runtime.taskmanager.TaskManager;
import org.apache.flink.runtime.taskmanager.TaskManager$;
import org.apache.flink.runtime.util.EnvironmentInformation;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001B\u0001\u0003\u00015\u0011Q\u0003T8dC24E.\u001b8l\u001b&t\u0017n\u00117vgR,'O\u0003\u0002\u0004\t\u0005YQ.\u001b8jG2,8\u000f^3s\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0011\r2Lgn['j]&\u001cE.^:uKJD\u0011b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001\u0006\u000e\u0002#U\u001cXM]\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!!\u0007\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0013\t\u0019\u0002\u0003C\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001eG\u0005\t2/\u001b8hY\u0016\f5\r^8s'f\u001cH/Z7\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\u000f\t{w\u000e\\3b]&\u0011A\u0005E\u0001\u0015kN,7+\u001b8hY\u0016\f5\r^8s'f\u001cH/Z7\t\u000b\u0019\u0002A\u0011A\u0014\u0002\rqJg.\u001b;?)\rA\u0013F\u000b\t\u0003\u001f\u0001AQaE\u0013A\u0002QAQ\u0001H\u0013A\u0002uAQA\n\u0001\u0005\u00021\"\"\u0001K\u0017\t\u000bMY\u0003\u0019\u0001\u000b\t\u000b=\u0002A\u0011\t\u0019\u0002+\u001d,g.\u001a:bi\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\u0011A#\r\u0005\u0006'9\u0002\r\u0001\u0006\u0005\u0006g\u0001!\t\u0005N\u0001\u0010gR\f'\u000f\u001e&pE6\u000bg.Y4feR\u0019Q'\u0010\"\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B1di>\u0014(\"\u0001\u001e\u0002\t\u0005\\7.Y\u0005\u0003y]\u0012\u0001\"Q2u_J\u0014VM\u001a\u0005\u0006}I\u0002\raP\u0001\u0006S:$W\r\u001f\t\u0003=\u0001K!!Q\u0010\u0003\u0007%sG\u000fC\u0003De\u0001\u0007A)\u0001\u0004tsN$X-\u001c\t\u0003m\u0015K!AR\u001c\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\u0006\u0011\u0002!\t%S\u0001\u0011gR\f'\u000f\u001e+bg.l\u0015M\\1hKJ$2!\u000e&L\u0011\u0015qt\t1\u0001@\u0011\u0015\u0019u\t1\u0001E\u0011\u0015i\u0005\u0001\"\u0001O\u0003A9W\r\u001e'fC\u0012,'O\u0015)D!>\u0014H/F\u0001@\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003eIg.\u001b;jC2L'0Z%P\r>\u0014X.\u0019;DY\u0006\u001c8/Z:\u0015\u0005I+\u0006C\u0001\u0010T\u0013\t!vD\u0001\u0003V]&$\b\"B\fP\u0001\u0004!\u0002\"B,\u0001\t\u0003A\u0016!C:fi6+Wn\u001c:z)\t\u0011\u0016\fC\u0003[-\u0002\u0007A#\u0001\u0004d_:4\u0017n\u001a\u0005\u00069\u0002!\t!X\u0001\u0011O\u0016$H)\u001a4bk2$8i\u001c8gS\u001e,\u0012\u0001\u0006\u0005\u0006?\u0002!\t\u0002Y\u0001\u0012O\u0016$(j\u001c2NC:\fw-\u001a:OC6,GCA1i!\t\u0011WM\u0004\u0002\u001fG&\u0011AmH\u0001\u0007!J,G-\u001a4\n\u0005\u0019<'AB*ue&twM\u0003\u0002e?!)aH\u0018a\u0001\u007f!)!\u000e\u0001C\tW\u0006qq-\u001a;Be\u000eD\u0017N^3OC6,GCA1m\u0011\u0015q\u0014\u000e1\u0001@\u0011\u0015q\u0007\u0001\"\u0001p\u0003Q\u0019WO\u001d:f]Rd\u0017PU;o]&twMS8cgV\t\u0001\u000fE\u0002rsrt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005Ud\u0011A\u0002\u001fs_>$h(C\u0001!\u0013\tAx$A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(\u0001C%uKJ\f'\r\\3\u000b\u0005a|\u0002cA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\taaY8n[>t'bAA\u0002\r\u0005\u0019\u0011\r]5\n\u0007\u0005\u001daPA\u0003K_\nLE\tC\u0004\u0002\f\u0001!\t!!\u0004\u00027\u001d,GoQ;se\u0016tG\u000f\\=Sk:t\u0017N\\4K_\n\u001c(*\u0019<b)\t\ty\u0001E\u0003\u0002\u0012\u0005mA0\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\t!A*[:u\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tqa\u001d;pa*{'\rF\u0002S\u0003KAq!a\n\u0002 \u0001\u0007A0\u0001\u0002jI\u0002")
public class LocalFlinkMiniCluster
extends FlinkMiniCluster {
    /*
     * WARNING - void declaration
     */
    @Override
    public Configuration generateConfiguration(Configuration userConfiguration) {
        void var2_2;
        Configuration config = this.getDefaultConfig();
        this.setDefaultCiConfig(config);
        config.addAll(userConfiguration);
        this.setMemory(config);
        this.initializeIOFormatClasses(config);
        return var2_2;
    }

    @Override
    public ActorRef startJobManager(int index, ActorSystem system) {
        Tuple2<ActorRef, ActorRef> tuple2;
        Configuration config = this.configuration().clone();
        String jobManagerName = this.getJobManagerName(index);
        String archiveName = this.getArchiveName(index);
        int jobManagerPort = config.getInteger("jobmanager.rpc.port", 6123);
        if (jobManagerPort > 0) {
            config.setInteger("jobmanager.rpc.port", jobManagerPort + index);
        }
        if ((tuple2 = JobManager$.MODULE$.startJobManagerActors(config, system, (Option<String>)new Some((Object)jobManagerName), (Option<String>)new Some((Object)archiveName), JobManager.class, MemoryArchivist.class)) != null) {
            ActorRef jobManager;
            ActorRef actorRef;
            ActorRef jobManager2 = actorRef = (jobManager = (ActorRef)tuple2._1());
            return jobManager2;
        }
        throw new MatchError(tuple2);
    }

    @Override
    public ActorRef startTaskManager(int index, ActorSystem system) {
        Configuration config = this.configuration().clone();
        int rpcPort = config.getInteger("taskmanager.rpc.port", 0);
        int dataPort = config.getInteger("taskmanager.data.port", 0);
        if (rpcPort > 0) {
            config.setInteger("taskmanager.rpc.port", rpcPort + index);
        }
        if (dataPort > 0) {
            config.setInteger("taskmanager.data.port", dataPort + index);
        }
        boolean localExecution = this.numTaskManagers() == 1;
        String taskManagerActorName = super.useSingleActorSystem() ? new StringBuilder().append((Object)TaskManager$.MODULE$.TASK_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : TaskManager$.MODULE$.TASK_MANAGER_NAME();
        return TaskManager$.MODULE$.startTaskManagerComponentsAndActor(config, system, this.hostname(), (Option<String>)new Some((Object)taskManagerActorName), (Option<LeaderRetrievalService>)new Some((Object)this.createLeaderRetrievalService()), localExecution, TaskManager.class);
    }

    public int getLeaderRPCPort() {
        Option<Seq<ActorSystem>> option;
        block4: {
            Option option2;
            block7: {
                int n;
                block6: {
                    block5: {
                        int p;
                        int index = this.getLeaderIndex(this.timeout());
                        option = this.jobManagerActorSystems();
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        Seq jmActorSystems = (Seq)some.x();
                        option2 = AkkaUtils$.MODULE$.getAddress((ActorSystem)jmActorSystems.apply(index)).port();
                        if (!(option2 instanceof Some)) break block5;
                        Some some2 = (Some)option2;
                        n = p = BoxesRunTime.unboxToInt((Object)some2.x());
                        break block6;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option3 = option2;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                    n = -1;
                }
                int n2 = n;
                return n2;
            }
            throw new MatchError((Object)option2);
        }
        None$ none$ = None$.MODULE$;
        Option<Seq<ActorSystem>> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new Exception("The JobManager of the LocalFlinkMiniCluster has not been started properly.");
        }
        throw new MatchError(option);
    }

    public void initializeIOFormatClasses(Configuration configuration) {
        try {
            Method om = FileOutputFormat.class.getDeclaredMethod("initDefaultsFromConfiguration", Configuration.class);
            om.setAccessible(true);
            om.invoke(null, configuration);
        }
        catch (Exception exception) {
            this.LOG().error("Cannot (re) initialize the globally loaded defaults. Some classes might not follow the specified default behaviour.");
        }
    }

    public void setMemory(Configuration config) {
        if (config.getInteger("taskmanager.memory.size", -1) == -1) {
            int bufferSize = config.getInteger("taskmanager.memory.segment-size", 32768);
            long bufferMem = config.getLong("taskmanager.network.numberOfBuffers", 2048L) * (long)bufferSize;
            int numTaskManager = config.getInteger("local.number-taskmanager", 1);
            float memoryFraction = config.getFloat("taskmanager.memory.fraction", 0.7f);
            long memorySize = EnvironmentInformation.getSizeOfFreeHeapMemoryWithDefrag();
            memorySize /= (long)(numTaskManager + 1);
            memorySize -= bufferMem;
            memorySize = (long)((double)memorySize * (double)memoryFraction);
            config.setLong("taskmanager.memory.size", memorySize >>>= 20);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getDefaultConfig() {
        void var1_1;
        Configuration config = new Configuration();
        config.setString("jobmanager.rpc.address", this.hostname());
        config.setInteger("local.number-taskmanager", 1);
        config.setInteger(NettyConfig.NUM_THREADS_CLIENT, 1);
        config.setInteger(NettyConfig.NUM_THREADS_SERVER, 2);
        return var1_1;
    }

    public String getJobManagerName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobManager$.MODULE$.JOB_MANAGER_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobManager$.MODULE$.JOB_MANAGER_NAME();
    }

    public String getArchiveName(int index) {
        return super.useSingleActorSystem() ? new StringBuilder().append((Object)JobManager$.MODULE$.ARCHIVE_NAME()).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)(index + 1))).toString() : JobManager$.MODULE$.ARCHIVE_NAME();
    }

    public Iterable<JobID> currentlyRunningJobs() {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future future = leader.ask(JobManagerMessages$RequestRunningJobsStatus$.MODULE$, this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.RunningJobsStatus.class));
        return (Iterable)((JobManagerMessages.RunningJobsStatus)Await$.MODULE$.result((Awaitable)future, (Duration)this.timeout())).runningJobs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final JobID apply(JobStatusMessage x$1) {
                return x$1.getJobId();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public List<JobID> getCurrentlyRunningJobsJava() {
        void var1_1;
        ArrayList list = new ArrayList();
        this.currentlyRunningJobs().foreach((Function1)new Serializable(this, list){
            public static final long serialVersionUID = 0L;
            private final ArrayList list$1;

            public final boolean apply(JobID x$1) {
                return this.list$1.add(x$1);
            }
            {
                this.list$1 = list$1;
            }
        });
        return var1_1;
    }

    public void stopJob(JobID id) {
        ActorGateway leader = this.getLeaderGateway(this.timeout());
        Future response = leader.ask(new JobManagerMessages.StopJob(id), this.timeout()).mapTo(ClassTag$.MODULE$.apply(JobManagerMessages.StoppingResponse.class));
        JobManagerMessages.StoppingResponse rc = (JobManagerMessages.StoppingResponse)Await$.MODULE$.result((Awaitable)response, (Duration)this.timeout());
        JobManagerMessages.StoppingResponse stoppingResponse = rc;
        if (stoppingResponse instanceof JobManagerMessages.StoppingFailure) {
            JobManagerMessages.StoppingFailure stoppingFailure = (JobManagerMessages.StoppingFailure)stoppingResponse;
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping the job with ID ", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id})), stoppingFailure.cause());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration, boolean singleActorSystem) {
        super(userConfiguration, singleActorSystem);
    }

    public LocalFlinkMiniCluster(Configuration userConfiguration) {
        this(userConfiguration, true);
    }
}

