/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConfig.class);
    public static final String NUM_ARENAS = "taskmanager.net.num-arenas";
    public static final String NUM_THREADS_SERVER = "taskmanager.net.server.numThreads";
    public static final String NUM_THREADS_CLIENT = "taskmanager.net.client.numThreads";
    public static final String CONNECT_BACKLOG = "taskmanager.net.server.backlog";
    public static final String CLIENT_CONNECT_TIMEOUT_SECONDS = "taskmanager.net.client.connectTimeoutSec";
    public static final String SEND_RECEIVE_BUFFER_SIZE = "taskmanager.net.sendReceiveBufferSize";
    public static final String TRANSPORT_TYPE = "taskmanager.net.transport";
    static final String SERVER_THREAD_GROUP_NAME = "Flink Netty Server";
    static final String CLIENT_THREAD_GROUP_NAME = "Flink Netty Client";
    private final InetAddress serverAddress;
    private final int serverPort;
    private final int memorySegmentSize;
    private final int numberOfSlots;
    private final Configuration config;

    public NettyConfig(InetAddress serverAddress, int serverPort, int memorySegmentSize, int numberOfSlots, Configuration config) {
        this.serverAddress = Preconditions.checkNotNull(serverAddress);
        Preconditions.checkArgument(serverPort > 0 && serverPort <= 65536, "Invalid port number.");
        this.serverPort = serverPort;
        Preconditions.checkArgument(memorySegmentSize > 0, "Invalid memory segment size.");
        this.memorySegmentSize = memorySegmentSize;
        Preconditions.checkArgument(numberOfSlots > 0, "Number of slots");
        this.numberOfSlots = numberOfSlots;
        this.config = Preconditions.checkNotNull(config);
        LOG.info(this.toString());
    }

    InetAddress getServerAddress() {
        return this.serverAddress;
    }

    int getServerPort() {
        return this.serverPort;
    }

    int getMemorySegmentSize() {
        return this.memorySegmentSize;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public NettyConfig setServerConnectBacklog(int connectBacklog) {
        Preconditions.checkArgument(connectBacklog >= 0);
        this.config.setInteger(CONNECT_BACKLOG, connectBacklog);
        return this;
    }

    public NettyConfig setServerNumThreads(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0);
        this.config.setInteger(NUM_THREADS_SERVER, numThreads);
        return this;
    }

    public NettyConfig setClientNumThreads(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0);
        this.config.setInteger(NUM_THREADS_CLIENT, numThreads);
        return this;
    }

    public NettyConfig setClientConnectTimeoutSeconds(int connectTimeoutSeconds) {
        Preconditions.checkArgument(connectTimeoutSeconds >= 0);
        this.config.setInteger(CLIENT_CONNECT_TIMEOUT_SECONDS, connectTimeoutSeconds);
        return this;
    }

    public NettyConfig setSendAndReceiveBufferSize(int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 0);
        this.config.setInteger(SEND_RECEIVE_BUFFER_SIZE, bufferSize);
        return this;
    }

    public NettyConfig setTransportType(String transport) {
        if (!(transport.equals("nio") || transport.equals("epoll") || transport.equals("auto"))) {
            throw new IllegalArgumentException("Unknown transport type.");
        }
        this.config.setString(TRANSPORT_TYPE, transport);
        return this;
    }

    public int getServerConnectBacklog() {
        return this.config.getInteger(CONNECT_BACKLOG, 0);
    }

    public int getNumberOfArenas() {
        return this.config.getInteger(NUM_ARENAS, this.numberOfSlots);
    }

    public int getServerNumThreads() {
        return this.config.getInteger(NUM_THREADS_SERVER, this.numberOfSlots);
    }

    public int getClientNumThreads() {
        return this.config.getInteger(NUM_THREADS_CLIENT, this.numberOfSlots);
    }

    public int getClientConnectTimeoutSeconds() {
        return this.config.getInteger(CLIENT_CONNECT_TIMEOUT_SECONDS, 120);
    }

    public int getSendAndReceiveBufferSize() {
        return this.config.getInteger(SEND_RECEIVE_BUFFER_SIZE, 0);
    }

    public TransportType getTransportType() {
        String transport = this.config.getString(TRANSPORT_TYPE, "nio");
        if (transport.equals("nio")) {
            return TransportType.NIO;
        }
        if (transport.equals("epoll")) {
            return TransportType.EPOLL;
        }
        return TransportType.AUTO;
    }

    public String toString() {
        String format = "NettyConfig [server address: %s, server port: %d, memory segment size (bytes): %d, transport type: %s, number of server threads: %d (%s), number of client threads: %d (%s), server connect backlog: %d (%s), client connect timeout (sec): %d, send/receive buffer size (bytes): %d (%s)]";
        String def = "use Netty's default";
        String man = "manual";
        return String.format(format, new Object[]{this.serverAddress, this.serverPort, this.memorySegmentSize, this.getTransportType(), this.getServerNumThreads(), this.getServerNumThreads() == 0 ? def : man, this.getClientNumThreads(), this.getClientNumThreads() == 0 ? def : man, this.getServerConnectBacklog(), this.getServerConnectBacklog() == 0 ? def : man, this.getClientConnectTimeoutSeconds(), this.getSendAndReceiveBufferSize(), this.getSendAndReceiveBufferSize() == 0 ? def : man});
    }

    static enum TransportType {
        NIO,
        EPOLL,
        AUTO;

    }
}

