/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.restart;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.executiongraph.restart.FixedDelayRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.NoRestartStrategy;
import org.apache.flink.runtime.executiongraph.restart.RestartStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.Duration;

public class RestartStrategyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RestartStrategyFactory.class);
    private static final String CREATE_METHOD = "create";

    public static RestartStrategy createRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        if (restartStrategyConfiguration instanceof RestartStrategies.NoRestartStrategyConfiguration) {
            return new NoRestartStrategy();
        }
        if (restartStrategyConfiguration instanceof RestartStrategies.FixedDelayRestartStrategyConfiguration) {
            RestartStrategies.FixedDelayRestartStrategyConfiguration fixedDelayConfig = (RestartStrategies.FixedDelayRestartStrategyConfiguration)restartStrategyConfiguration;
            return new FixedDelayRestartStrategy(fixedDelayConfig.getRestartAttempts(), fixedDelayConfig.getDelayBetweenAttempts());
        }
        throw new IllegalArgumentException("Unknown restart strategy configuration " + restartStrategyConfiguration + ".");
    }

    public static RestartStrategy createFromConfig(Configuration configuration) throws Exception {
        String restartStrategyName;
        switch (restartStrategyName = configuration.getString("restart-strategy", "none").toLowerCase()) {
            case "none": {
                long delay;
                int numberExecutionRetries = configuration.getInteger("execution-retries.default", 0);
                String pauseString = configuration.getString("akka.watch.heartbeat.pause", ConfigConstants.DEFAULT_AKKA_ASK_TIMEOUT);
                String delayString = configuration.getString("execution-retries.delay", pauseString);
                try {
                    delay = Duration.apply((String)delayString).toMillis();
                }
                catch (NumberFormatException nfe) {
                    if (delayString.equals(pauseString)) {
                        throw new Exception("Invalid config value for akka.watch.heartbeat.pause: " + pauseString + ". Value must be a valid duration (such as '10 s' or '1 min')");
                    }
                    throw new Exception("Invalid config value for execution-retries.delay: " + delayString + ". Value must be a valid duration (such as '100 milli' or '10 s')");
                }
                if (numberExecutionRetries > 0 && delay >= 0L) {
                    return new FixedDelayRestartStrategy(numberExecutionRetries, delay);
                }
                return NoRestartStrategy.create(configuration);
            }
            case "off": 
            case "disable": {
                return NoRestartStrategy.create(configuration);
            }
            case "fixeddelay": 
            case "fixed-delay": {
                return FixedDelayRestartStrategy.create(configuration);
            }
        }
        try {
            Object result;
            Method method;
            Class<?> clazz = Class.forName(restartStrategyName);
            if (clazz != null && (method = clazz.getMethod(CREATE_METHOD, Configuration.class)) != null && (result = method.invoke(null, configuration)) != null) {
                return (RestartStrategy)result;
            }
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warn("Could not find restart strategy class {}.", (Object)restartStrategyName);
        }
        catch (NoSuchMethodException nsme) {
            LOG.warn("Class {} does not has static method {}.", (Object)restartStrategyName, (Object)CREATE_METHOD);
        }
        catch (InvocationTargetException ite) {
            LOG.warn("Cannot call static method {} from class {}.", (Object)CREATE_METHOD, (Object)restartStrategyName);
        }
        catch (IllegalAccessException iae) {
            LOG.warn("Illegal access while calling method {} from class {}.", (Object)CREATE_METHOD, (Object)restartStrategyName);
        }
        return NoRestartStrategy.create(configuration);
    }
}

