/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.StateForTask;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStats;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.stats.JobCheckpointStats;
import org.apache.flink.runtime.checkpoint.stats.OperatorCheckpointStats;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import scala.Option;

public class SimpleCheckpointStatsTracker
implements CheckpointStatsTracker {
    private final Object statsLock = new Object();
    private final int historySize;
    private final ArrayList<CheckpointStats> history = new ArrayList();
    private final Map<JobVertexID, Integer> taskParallelism;
    private Map<JobVertexID, long[][]> subTaskStats;
    private JobCheckpointStats lastJobStats;
    private Map<JobVertexID, OperatorCheckpointStats> operatorStatsCache = new HashMap<JobVertexID, OperatorCheckpointStats>();
    private long overallCount;
    private long overallMinDuration = Long.MAX_VALUE;
    private long overallMaxDuration = Long.MIN_VALUE;
    private long overallTotalDuration;
    private long overallMinStateSize = Long.MAX_VALUE;
    private long overallMaxStateSize = Long.MIN_VALUE;
    private long overallTotalStateSize;
    private CompletedCheckpoint latestCompletedCheckpoint;

    public SimpleCheckpointStatsTracker(int historySize, ExecutionVertex[] tasksToWaitFor) {
        Preconditions.checkArgument(historySize >= 0);
        this.historySize = historySize;
        if (tasksToWaitFor != null && tasksToWaitFor.length > 0) {
            this.taskParallelism = new HashMap<JobVertexID, Integer>();
            for (ExecutionVertex vertex : tasksToWaitFor) {
                this.taskParallelism.put(vertex.getJobvertexId(), vertex.getTotalNumberOfParallelSubtasks());
            }
        } else {
            this.taskParallelism = Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompletedCheckpoint(CompletedCheckpoint checkpoint) {
        if (this.taskParallelism.isEmpty()) {
            return;
        }
        Object object = this.statsLock;
        synchronized (object) {
            long overallStateSize = 0L;
            HashMap<JobVertexID, long[][]> statsForSubTasks = new HashMap<JobVertexID, long[][]>();
            for (StateForTask state : checkpoint.getStates()) {
                int subTaskIndex;
                overallStateSize += state.getStateSize();
                JobVertexID opId = state.getOperatorId();
                long[][] statsPerSubtask = (long[][])statsForSubTasks.get((Object)opId);
                if (statsPerSubtask == null) {
                    int parallelism = this.taskParallelism.get((Object)opId);
                    statsPerSubtask = new long[parallelism][2];
                    statsForSubTasks.put(opId, statsPerSubtask);
                }
                if ((subTaskIndex = state.getSubtask()) >= statsPerSubtask.length) continue;
                statsPerSubtask[subTaskIndex][0] = state.getDuration();
                statsPerSubtask[subTaskIndex][1] = state.getStateSize();
            }
            boolean isInOrder = this.latestCompletedCheckpoint != null && checkpoint.getCheckpointID() > this.latestCompletedCheckpoint.getCheckpointID();
            this.lastJobStats = null;
            if (this.overallCount == 0L || isInOrder) {
                this.latestCompletedCheckpoint = checkpoint;
                this.operatorStatsCache.clear();
                this.subTaskStats = statsForSubTasks;
            }
            long checkpointId = checkpoint.getCheckpointID();
            long checkpointTriggerTimestamp = checkpoint.getTimestamp();
            long checkpointDuration = checkpoint.getDuration();
            ++this.overallCount;
            if (checkpointDuration > this.overallMaxDuration) {
                this.overallMaxDuration = checkpointDuration;
            }
            if (checkpointDuration < this.overallMinDuration) {
                this.overallMinDuration = checkpointDuration;
            }
            this.overallTotalDuration += checkpointDuration;
            if (overallStateSize < this.overallMinStateSize) {
                this.overallMinStateSize = overallStateSize;
            }
            if (overallStateSize > this.overallMaxStateSize) {
                this.overallMaxStateSize = overallStateSize;
            }
            this.overallTotalStateSize += overallStateSize;
            if (this.historySize > 0) {
                CheckpointStats stats = new CheckpointStats(checkpointId, checkpointTriggerTimestamp, checkpointDuration, overallStateSize);
                if (isInOrder) {
                    if (this.history.size() == this.historySize) {
                        this.history.remove(0);
                    }
                    this.history.add(stats);
                } else {
                    int size = this.history.size();
                    if (size == this.historySize && checkpointId > this.history.get(0).getCheckpointId()) {
                        this.history.remove(0);
                    }
                    int pos = 0;
                    for (int i = 0; i < size; ++i) {
                        pos = i;
                        if (checkpointId < this.history.get(i).getCheckpointId()) break;
                    }
                    this.history.add(pos, stats);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<JobCheckpointStats> getJobStats() {
        Object object = this.statsLock;
        synchronized (object) {
            if (this.lastJobStats != null) {
                return Option.apply((Object)this.lastJobStats);
            }
            if (this.latestCompletedCheckpoint != null) {
                long overallAverageDuration = this.overallCount == 0L ? 0L : this.overallTotalDuration / this.overallCount;
                long overallAverageStateSize = this.overallCount == 0L ? 0L : this.overallTotalStateSize / this.overallCount;
                this.lastJobStats = new JobCheckpointStatsSnapshot((List)this.history.clone(), this.overallCount, this.overallMinDuration, this.overallMaxDuration, overallAverageDuration, this.overallMinStateSize, this.overallMaxStateSize, overallAverageStateSize);
                return Option.apply((Object)this.lastJobStats);
            }
            return Option.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Option<OperatorCheckpointStats> getOperatorStats(JobVertexID operatorId) {
        Object object = this.statsLock;
        synchronized (object) {
            OperatorCheckpointStats stats = this.operatorStatsCache.get((Object)operatorId);
            if (stats != null) {
                return Option.apply((Object)stats);
            }
            if (this.latestCompletedCheckpoint != null && this.subTaskStats != null) {
                long[][] subTaskStats = this.subTaskStats.get((Object)operatorId);
                if (subTaskStats == null) {
                    return Option.empty();
                }
                long maxDuration = Long.MIN_VALUE;
                long stateSize = 0L;
                for (long[] subTaskStat : subTaskStats) {
                    if (subTaskStat[0] > maxDuration) {
                        maxDuration = subTaskStat[0];
                    }
                    stateSize += subTaskStat[1];
                }
                stats = new OperatorCheckpointStats(this.latestCompletedCheckpoint.getCheckpointID(), this.latestCompletedCheckpoint.getTimestamp(), maxDuration, stateSize, subTaskStats);
                this.operatorStatsCache.put(operatorId, stats);
                return Option.apply((Object)stats);
            }
            return Option.empty();
        }
    }

    private static class JobCheckpointStatsSnapshot
    implements JobCheckpointStats {
        private final List<CheckpointStats> recentHistory;
        private final long count;
        private final long minDuration;
        private final long maxDuration;
        private final long averageDuration;
        private final long minStateSize;
        private final long maxStateSize;
        private final long averageStateSize;

        public JobCheckpointStatsSnapshot(List<CheckpointStats> recentHistory, long count, long minDuration, long maxDuration, long averageDuration, long minStateSize, long maxStateSize, long averageStateSize) {
            this.recentHistory = recentHistory;
            this.count = count;
            this.minDuration = minDuration;
            this.maxDuration = maxDuration;
            this.averageDuration = averageDuration;
            this.minStateSize = minStateSize;
            this.maxStateSize = maxStateSize;
            this.averageStateSize = averageStateSize;
        }

        @Override
        public List<CheckpointStats> getRecentHistory() {
            return this.recentHistory;
        }

        @Override
        public long getCount() {
            return this.count;
        }

        @Override
        public long getMinDuration() {
            return this.minDuration;
        }

        @Override
        public long getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public long getAverageDuration() {
            return this.averageDuration;
        }

        @Override
        public long getMinStateSize() {
            return this.minStateSize;
        }

        @Override
        public long getMaxStateSize() {
            return this.maxStateSize;
        }

        @Override
        public long getAverageStateSize() {
            return this.averageStateSize;
        }
    }
}

