/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.stats;

import java.util.Arrays;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStats;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public class OperatorCheckpointStats
extends CheckpointStats {
    private final long[][] subTaskStats;

    public OperatorCheckpointStats(long checkpointId, long triggerTimestamp, long duration, long stateSize, long[][] subTaskStats) {
        super(checkpointId, triggerTimestamp, duration, stateSize);
        this.subTaskStats = Preconditions.checkNotNull(subTaskStats);
    }

    public int getNumberOfSubTasks() {
        return this.subTaskStats.length;
    }

    public long getSubTaskDuration(int index) {
        return this.subTaskStats[index][0];
    }

    public long getSubTaskStateSize(int index) {
        return this.subTaskStats[index][1];
    }

    @Override
    public String toString() {
        return "OperatorCheckpointStats{checkpointId=" + this.getCheckpointId() + ", subTaskStats=" + Arrays.deepToString((Object[])this.subTaskStats) + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorCheckpointStats that = (OperatorCheckpointStats)o;
        return this.getCheckpointId() == that.getCheckpointId() && this.getTriggerTimestamp() == that.getTriggerTimestamp() && Arrays.deepEquals((Object[])this.subTaskStats, (Object[])that.subTaskStats);
    }

    @Override
    public int hashCode() {
        int result = (int)(this.getCheckpointId() ^ this.getCheckpointId() >>> 32);
        result = 31 * result + (int)(this.getTriggerTimestamp() ^ this.getTriggerTimestamp() >>> 32);
        result = 31 * result + (this.subTaskStats.length ^ this.subTaskStats.length >>> 32);
        return result;
    }
}

