/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

class StandaloneCompletedCheckpointStore
implements CompletedCheckpointStore {
    private final int maxNumberOfCheckpointsToRetain;
    private final ClassLoader userClassLoader;
    private final ArrayDeque<CompletedCheckpoint> checkpoints;

    public StandaloneCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain, ClassLoader userClassLoader) {
        Preconditions.checkArgument(maxNumberOfCheckpointsToRetain >= 1, "Must retain at least one checkpoint.");
        this.maxNumberOfCheckpointsToRetain = maxNumberOfCheckpointsToRetain;
        this.userClassLoader = Preconditions.checkNotNull(userClassLoader, "User class loader");
        this.checkpoints = new ArrayDeque(maxNumberOfCheckpointsToRetain + 1);
    }

    @Override
    public void recover() throws Exception {
    }

    @Override
    public void addCheckpoint(CompletedCheckpoint checkpoint) {
        this.checkpoints.addLast(checkpoint);
        if (this.checkpoints.size() > this.maxNumberOfCheckpointsToRetain) {
            this.checkpoints.removeFirst().discard(this.userClassLoader);
        }
    }

    @Override
    public CompletedCheckpoint getLatestCheckpoint() {
        return this.checkpoints.isEmpty() ? null : this.checkpoints.getLast();
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public void discardAllCheckpoints() {
        for (CompletedCheckpoint checkpoint : this.checkpoints) {
            checkpoint.discard(this.userClassLoader);
        }
        this.checkpoints.clear();
    }
}

