/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.HeapStateStore;
import org.apache.flink.runtime.checkpoint.StateStore;

public class SavepointStore
implements StateStore<CompletedCheckpoint> {
    private final StateStore<CompletedCheckpoint> stateStore;

    public SavepointStore(StateStore<CompletedCheckpoint> stateStore) {
        this.stateStore = stateStore;
    }

    public void start() {
    }

    public void stop() {
        if (this.stateStore instanceof HeapStateStore) {
            HeapStateStore heapStateStore = (HeapStateStore)this.stateStore;
            for (CompletedCheckpoint savepoint : heapStateStore.getAll()) {
                savepoint.discard(ClassLoader.getSystemClassLoader());
            }
            heapStateStore.clearAll();
        }
    }

    @Override
    public String putState(CompletedCheckpoint state) throws Exception {
        return this.stateStore.putState(state);
    }

    @Override
    public CompletedCheckpoint getState(String path) throws Exception {
        return this.stateStore.getState(path);
    }

    @Override
    public void disposeState(String path) throws Exception {
        this.stateStore.disposeState(path);
    }

    StateStore<CompletedCheckpoint> getStateStore() {
        return this.stateStore;
    }
}

