/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.StateStore;
import org.apache.flink.runtime.state.filesystem.FileSerializableStateHandle;
import org.apache.flink.runtime.util.FileUtils;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

class FileSystemStateStore<T extends Serializable>
implements StateStore<T> {
    private final Path rootPath;
    private final String prefix;
    private final FileSystem fileSystem;

    FileSystemStateStore(String rootPath, String prefix) throws IOException {
        this(new Path(rootPath), prefix);
    }

    FileSystemStateStore(Path rootPath, String prefix) throws IOException {
        this.rootPath = Preconditions.checkNotNull(rootPath, "Root path");
        this.prefix = Preconditions.checkNotNull(prefix, "Prefix");
        this.fileSystem = FileSystem.get((URI)rootPath.toUri());
    }

    @Override
    public String putState(T state) throws Exception {
        Exception latestException = null;
        for (int attempt = 0; attempt < 10; ++attempt) {
            FSDataOutputStream outStream;
            Path filePath = new Path(this.rootPath, FileUtils.getRandomFilename(this.prefix));
            try {
                outStream = this.fileSystem.create(filePath, false);
            }
            catch (Exception e) {
                latestException = e;
                continue;
            }
            try (ObjectOutputStream os = new ObjectOutputStream((OutputStream)outStream);){
                os.writeObject(state);
            }
            return filePath.toString();
        }
        throw new IOException("Failed to open file output stream", latestException);
    }

    @Override
    public T getState(String path) throws Exception {
        Path filePath = new Path(path);
        if (FileSystem.get((URI)filePath.toUri()).exists(filePath)) {
            return (T)new FileSerializableStateHandle(filePath).getState(ClassLoader.getSystemClassLoader());
        }
        throw new IllegalArgumentException("Invalid path '" + filePath.toUri() + "'.");
    }

    @Override
    public void disposeState(String path) throws Exception {
        Path filePath = new Path(path);
        if (!this.fileSystem.delete(filePath, true)) {
            throw new IllegalArgumentException("Invalid path '" + filePath.toUri() + "'.");
        }
        try {
            this.fileSystem.delete(filePath.getParent(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Path getRootPath() {
        return this.rootPath;
    }
}

