/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.accumulators;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.runtime.accumulators.AccumulatorSnapshot;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorRegistry {
    protected static final Logger LOG = LoggerFactory.getLogger(AccumulatorRegistry.class);
    protected final JobID jobID;
    protected final ExecutionAttemptID taskID;
    private final Map<Metric, Accumulator<?, ?>> flinkAccumulators = new HashMap();
    private final Map<String, Accumulator<?, ?>> userAccumulators = Collections.synchronizedMap(new HashMap());
    private final ReadWriteReporter reporter;

    public AccumulatorRegistry(JobID jobID, ExecutionAttemptID taskID) {
        this.jobID = jobID;
        this.taskID = taskID;
        this.reporter = new ReadWriteReporter(this.flinkAccumulators);
    }

    public AccumulatorSnapshot getSnapshot() {
        try {
            return new AccumulatorSnapshot(this.jobID, this.taskID, this.flinkAccumulators, this.userAccumulators);
        }
        catch (IOException e) {
            LOG.warn("Failed to serialize accumulators for task.", (Throwable)e);
            return null;
        }
    }

    public Map<String, Accumulator<?, ?>> getUserMap() {
        return this.userAccumulators;
    }

    public Reporter getReadWriteReporter() {
        return this.reporter;
    }

    private static class ReadWriteReporter
    implements Reporter {
        private LongCounter numRecordsIn = new LongCounter();
        private LongCounter numRecordsOut = new LongCounter();
        private LongCounter numBytesIn = new LongCounter();
        private LongCounter numBytesOut = new LongCounter();

        private ReadWriteReporter(Map<Metric, Accumulator<?, ?>> accumulatorMap) {
            accumulatorMap.put(Metric.NUM_RECORDS_IN, (Accumulator<?, ?>)this.numRecordsIn);
            accumulatorMap.put(Metric.NUM_RECORDS_OUT, (Accumulator<?, ?>)this.numRecordsOut);
            accumulatorMap.put(Metric.NUM_BYTES_IN, (Accumulator<?, ?>)this.numBytesIn);
            accumulatorMap.put(Metric.NUM_BYTES_OUT, (Accumulator<?, ?>)this.numBytesOut);
        }

        @Override
        public void reportNumRecordsIn(long value) {
            this.numRecordsIn.add(value);
        }

        @Override
        public void reportNumRecordsOut(long value) {
            this.numRecordsOut.add(value);
        }

        @Override
        public void reportNumBytesIn(long value) {
            this.numBytesIn.add(value);
        }

        @Override
        public void reportNumBytesOut(long value) {
            this.numBytesOut.add(value);
        }
    }

    public static interface Reporter {
        public void reportNumRecordsIn(long var1);

        public void reportNumRecordsOut(long var1);

        public void reportNumBytesIn(long var1);

        public void reportNumBytesOut(long var1);
    }

    public static enum Metric {
        NUM_RECORDS_IN,
        NUM_RECORDS_OUT,
        NUM_BYTES_IN,
        NUM_BYTES_OUT;

    }
}

