/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.threadinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexFlameGraph;
import org.apache.flink.runtime.webmonitor.threadinfo.VertexThreadInfoStats;

public class VertexFlameGraphFactory {
    public static VertexFlameGraph createFullFlameGraphFrom(VertexThreadInfoStats sample) {
        EnumSet<Thread.State> included = EnumSet.allOf(Thread.State.class);
        return VertexFlameGraphFactory.createFlameGraphFromSample(sample, included);
    }

    public static VertexFlameGraph createOffCpuFlameGraph(VertexThreadInfoStats sample) {
        EnumSet<Thread.State> included = EnumSet.of(Thread.State.TIMED_WAITING, Thread.State.BLOCKED, Thread.State.WAITING);
        return VertexFlameGraphFactory.createFlameGraphFromSample(sample, included);
    }

    public static VertexFlameGraph createOnCpuFlameGraph(VertexThreadInfoStats sample) {
        EnumSet<Thread.State> included = EnumSet.of(Thread.State.RUNNABLE, Thread.State.NEW);
        return VertexFlameGraphFactory.createFlameGraphFromSample(sample, included);
    }

    private static VertexFlameGraph createFlameGraphFromSample(VertexThreadInfoStats sample, Set<Thread.State> threadStates) {
        NodeBuilder root = new NodeBuilder("root");
        for (Collection<ThreadInfoSample> threadInfoSubSamples : sample.getSamplesBySubtask().values()) {
            for (ThreadInfoSample threadInfo : threadInfoSubSamples) {
                if (!threadStates.contains((Object)threadInfo.getThreadState())) continue;
                StackTraceElement[] traces = threadInfo.getStackTrace();
                root.incrementHitCount();
                NodeBuilder parent = root;
                for (int i = traces.length - 1; i >= 0; --i) {
                    String name = traces[i].getClassName() + "." + traces[i].getMethodName() + ":" + traces[i].getLineNumber();
                    parent = parent.addChild(name);
                }
            }
        }
        return new VertexFlameGraph(sample.getEndTime(), root.toNode());
    }

    private static class NodeBuilder {
        private final Map<String, NodeBuilder> children = new HashMap<String, NodeBuilder>();
        private final String stackTraceLocation;
        private int hitCount = 0;

        NodeBuilder(String stackTraceLocation) {
            this.stackTraceLocation = stackTraceLocation;
        }

        NodeBuilder addChild(String name) {
            NodeBuilder child = this.children.computeIfAbsent(name, NodeBuilder::new);
            child.incrementHitCount();
            return child;
        }

        void incrementHitCount() {
            ++this.hitCount;
        }

        private VertexFlameGraph.Node toNode() {
            ArrayList<VertexFlameGraph.Node> childrenNodes = new ArrayList<VertexFlameGraph.Node>(this.children.size());
            for (NodeBuilder builderChild : this.children.values()) {
                childrenNodes.add(builderChild.toNode());
            }
            return new VertexFlameGraph.Node(this.stackTraceLocation, this.hitCount, Collections.unmodifiableList(childrenNodes));
        }
    }
}

