/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.runtime.concurrent.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.highavailability.nonha.embedded.TestingLeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderContender;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.CompletableFutureAssert;
import org.junit.jupiter.api.Test;

class EmbeddedLeaderServiceTest {
    EmbeddedLeaderServiceTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentGrantLeadershipAndShutdown() throws Exception {
        ManuallyTriggeredScheduledExecutorService executorService = new ManuallyTriggeredScheduledExecutorService();
        EmbeddedLeaderService embeddedLeaderService = new EmbeddedLeaderService((Executor)executorService);
        try {
            LeaderElectionService leaderElectionService = embeddedLeaderService.createLeaderElectionService();
            TestingLeaderContender contender = new TestingLeaderContender();
            leaderElectionService.start((LeaderContender)contender);
            leaderElectionService.stop();
            ((CompletableFutureAssert)Assertions.assertThat(contender.getLeaderSessionFuture()).as("The future shouldn't have completed because the grant event wasn't processed, yet.", new Object[0])).isNotDone();
            Assertions.assertThat((boolean)embeddedLeaderService.isShutdown()).isFalse();
        }
        finally {
            embeddedLeaderService.shutdown();
            executorService.triggerAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentRevokeLeadershipAndShutdown() throws Exception {
        ManuallyTriggeredScheduledExecutorService executorService = new ManuallyTriggeredScheduledExecutorService();
        EmbeddedLeaderService embeddedLeaderService = new EmbeddedLeaderService((Executor)executorService);
        try {
            LeaderElectionService leaderElectionService = embeddedLeaderService.createLeaderElectionService();
            TestingLeaderContender contender = new TestingLeaderContender();
            leaderElectionService.start((LeaderContender)contender);
            executorService.trigger();
            contender.getLeaderSessionFuture().get();
            CompletableFuture revokeLeadershipFuture = embeddedLeaderService.revokeLeadership();
            leaderElectionService.stop();
            ((CompletableFutureAssert)Assertions.assertThat((CompletableFuture)revokeLeadershipFuture).as("The future shouldn't have completed because the revoke event wasn't processed, yet.", new Object[0])).isNotDone();
            Assertions.assertThat((boolean)embeddedLeaderService.isShutdown()).isFalse();
        }
        finally {
            embeddedLeaderService.shutdown();
            executorService.triggerAll();
        }
    }
}

