/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.hadoop;

import org.apache.flink.runtime.hadoop.HadoopUserUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;

class HadoopUserUtilsTest {
    HadoopUserUtilsTest() {
    }

    @BeforeAll
    public static void setPropertiesToEnableKerberosConfigInit() throws KrbException {
        System.setProperty("java.security.krb5.realm", "");
        System.setProperty("java.security.krb5.kdc", "");
        System.setProperty("java.security.krb5.conf", "/dev/null");
        Config.refresh();
    }

    @AfterAll
    public static void cleanupHadoopConfigs() {
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
    }

    @Test
    public void testIsProxyUserShouldReturnFalseWhenNormalUser() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUserUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userGroupInformation = HadoopUserUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.KERBEROS);
        Assertions.assertFalse((boolean)HadoopUserUtils.isProxyUser((UserGroupInformation)userGroupInformation));
    }

    @Test
    public void testIsProxyUserShouldReturnTrueWhenProxyUser() {
        UserGroupInformation.setConfiguration((Configuration)HadoopUserUtilsTest.getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod.KERBEROS));
        UserGroupInformation userGroupInformation = HadoopUserUtilsTest.createTestUser(UserGroupInformation.AuthenticationMethod.PROXY);
        Assertions.assertTrue((boolean)HadoopUserUtils.isProxyUser((UserGroupInformation)userGroupInformation));
    }

    private static Configuration getHadoopConfigWithAuthMethod(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        Configuration conf = new Configuration(true);
        conf.set("hadoop.security.authentication", authenticationMethod.name());
        return conf;
    }

    private static UserGroupInformation createTestUser(UserGroupInformation.AuthenticationMethod authenticationMethod) {
        UserGroupInformation user = UserGroupInformation.createRemoteUser((String)"test-user");
        user.setAuthenticationMethod(authenticationMethod);
        return user;
    }
}

