/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.StateEntry;
import org.apache.flink.runtime.state.StateSnapshotTransformer;
import org.apache.flink.runtime.state.heap.CopyOnWriteStateMap;
import org.apache.flink.runtime.state.heap.StateMapSnapshot;
import org.apache.flink.util.Preconditions;

public class CopyOnWriteStateMapSnapshot<K, N, S>
extends StateMapSnapshot<K, N, S, CopyOnWriteStateMap<K, N, S>> {
    private final int snapshotVersion;
    @Nonnull
    private final CopyOnWriteStateMap.StateMapEntry<K, N, S>[] snapshotData;
    @Nonnegative
    private final int numberOfEntriesInSnapshotData;
    private boolean released;

    CopyOnWriteStateMapSnapshot(CopyOnWriteStateMap<K, N, S> owningStateMap) {
        super(owningStateMap);
        this.snapshotData = owningStateMap.snapshotMapArrays();
        this.snapshotVersion = owningStateMap.getStateMapVersion();
        this.numberOfEntriesInSnapshotData = owningStateMap.size();
        this.released = false;
    }

    @Override
    public void release() {
        if (!this.released) {
            ((CopyOnWriteStateMap)this.owningStateMap).releaseSnapshot(this);
            this.released = true;
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    int getSnapshotVersion() {
        return this.snapshotVersion;
    }

    public SnapshotIterator<K, N, S> getIterator(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer, @Nonnull TypeSerializer<S> stateSerializer, @Nullable StateSnapshotTransformer<S> stateSnapshotTransformer) {
        return stateSnapshotTransformer == null ? new NonTransformSnapshotIterator<K, N, S>(this.numberOfEntriesInSnapshotData, this.snapshotData) : new TransformedSnapshotIterator<K, N, S>(this.numberOfEntriesInSnapshotData, this.snapshotData, stateSnapshotTransformer);
    }

    @Override
    public void writeState(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer, TypeSerializer<S> stateSerializer, @Nonnull DataOutputView dov, @Nullable StateSnapshotTransformer<S> stateSnapshotTransformer) throws IOException {
        Iterator snapshotIterator = this.getIterator((TypeSerializer)keySerializer, (TypeSerializer)namespaceSerializer, (TypeSerializer)stateSerializer, (StateSnapshotTransformer)stateSnapshotTransformer);
        int size = ((SnapshotIterator)snapshotIterator).size();
        dov.writeInt(size);
        while (((SnapshotIterator)snapshotIterator).hasNext()) {
            Object stateEntry = ((SnapshotIterator)snapshotIterator).next();
            namespaceSerializer.serialize(stateEntry.getNamespace(), dov);
            keySerializer.serialize(stateEntry.getKey(), dov);
            stateSerializer.serialize(stateEntry.getState(), dov);
        }
    }

    static class TransformedSnapshotIterator<K, N, S>
    extends SnapshotIterator<K, N, S> {
        TransformedSnapshotIterator(int numberOfEntriesInSnapshotData, CopyOnWriteStateMap.StateMapEntry<K, N, S>[] snapshotData, @Nonnull StateSnapshotTransformer<S> stateSnapshotTransformer) {
            super(numberOfEntriesInSnapshotData, snapshotData, stateSnapshotTransformer);
        }

        int moveChainsToBackOfArray() {
            int index;
            for (index = this.snapshotData.length - 1; index >= 0 && this.snapshotData[index] != null; --index) {
            }
            int lastNullIndex = index--;
            while (index >= 0) {
                CopyOnWriteStateMap.StateMapEntry entry = this.snapshotData[index];
                if (entry != null) {
                    this.snapshotData[lastNullIndex] = entry;
                    this.snapshotData[index] = null;
                    --lastNullIndex;
                }
                --index;
            }
            return lastNullIndex + 1;
        }

        @Override
        void transform(@Nullable StateSnapshotTransformer<S> stateSnapshotTransformer) {
            Preconditions.checkNotNull(stateSnapshotTransformer);
            int indexOfFirstChain = this.moveChainsToBackOfArray();
            int count = 0;
            for (int i = indexOfFirstChain; i < this.snapshotData.length; ++i) {
                CopyOnWriteStateMap.StateMapEntry entry = this.snapshotData[i];
                while (entry != null) {
                    S transformedValue = stateSnapshotTransformer.filterOrTransform(entry.state);
                    if (transformedValue != null) {
                        CopyOnWriteStateMap.StateMapEntry filteredEntry = entry;
                        if (transformedValue != entry.state) {
                            filteredEntry = new CopyOnWriteStateMap.StateMapEntry(entry, entry.entryVersion);
                            filteredEntry.state = transformedValue;
                        }
                        this.snapshotData[count++] = filteredEntry;
                    }
                    entry = entry.next;
                }
            }
            this.numberOfEntriesInSnapshotData = count;
        }

        @Override
        public int size() {
            return this.numberOfEntriesInSnapshotData;
        }

        @Override
        Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> getChainIterator() {
            return Arrays.stream(this.snapshotData, 0, this.numberOfEntriesInSnapshotData).iterator();
        }

        @Override
        Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> getEntryIterator(CopyOnWriteStateMap.StateMapEntry<K, N, S> stateMapEntry) {
            return Collections.singleton(stateMapEntry).iterator();
        }
    }

    static class NonTransformSnapshotIterator<K, N, S>
    extends SnapshotIterator<K, N, S> {
        NonTransformSnapshotIterator(int numberOfEntriesInSnapshotData, CopyOnWriteStateMap.StateMapEntry<K, N, S>[] snapshotData) {
            super(numberOfEntriesInSnapshotData, snapshotData, null);
        }

        @Override
        void transform(@Nullable StateSnapshotTransformer<S> stateSnapshotTransformer) {
        }

        @Override
        public int size() {
            return this.numberOfEntriesInSnapshotData;
        }

        @Override
        Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> getChainIterator() {
            return Arrays.stream(this.snapshotData).filter(Objects::nonNull).iterator();
        }

        @Override
        Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> getEntryIterator(final CopyOnWriteStateMap.StateMapEntry<K, N, S> stateMapEntry) {
            return new Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>>(){
                CopyOnWriteStateMap.StateMapEntry<K, N, S> nextEntry;
                {
                    this.nextEntry = stateMapEntry;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry != null;
                }

                @Override
                public CopyOnWriteStateMap.StateMapEntry<K, N, S> next() {
                    if (this.nextEntry == null) {
                        throw new NoSuchElementException();
                    }
                    CopyOnWriteStateMap.StateMapEntry entry = this.nextEntry;
                    this.nextEntry = this.nextEntry.next;
                    return entry;
                }
            };
        }
    }

    static abstract class SnapshotIterator<K, N, S>
    implements Iterator<StateEntry<K, N, S>> {
        int numberOfEntriesInSnapshotData;
        CopyOnWriteStateMap.StateMapEntry<K, N, S>[] snapshotData;
        Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> chainIterator;
        Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> entryIterator;

        SnapshotIterator(int numberOfEntriesInSnapshotData, CopyOnWriteStateMap.StateMapEntry<K, N, S>[] snapshotData, @Nullable StateSnapshotTransformer<S> stateSnapshotTransformer) {
            this.numberOfEntriesInSnapshotData = numberOfEntriesInSnapshotData;
            this.snapshotData = snapshotData;
            this.transform(stateSnapshotTransformer);
            this.chainIterator = this.getChainIterator();
            this.entryIterator = Collections.emptyIterator();
        }

        abstract int size();

        abstract void transform(@Nullable StateSnapshotTransformer<S> var1);

        abstract Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> getChainIterator();

        abstract Iterator<CopyOnWriteStateMap.StateMapEntry<K, N, S>> getEntryIterator(CopyOnWriteStateMap.StateMapEntry<K, N, S> var1);

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext() || this.chainIterator.hasNext();
        }

        @Override
        public CopyOnWriteStateMap.StateMapEntry<K, N, S> next() {
            if (this.entryIterator.hasNext()) {
                return this.entryIterator.next();
            }
            CopyOnWriteStateMap.StateMapEntry<K, N, S> stateMapEntry = this.chainIterator.next();
            this.entryIterator = this.getEntryIterator(stateMapEntry);
            return this.entryIterator.next();
        }
    }
}

