/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.junit.Assert;
import org.junit.Test;

public class TaskExecutionStateTest {
    @Test
    public void testEqualsHashCode() {
        try {
            ExecutionAttemptID executionId = new ExecutionAttemptID();
            ExecutionState state = ExecutionState.RUNNING;
            RuntimeException error = new RuntimeException("some test error message");
            TaskExecutionState s1 = new TaskExecutionState(executionId, state, (Throwable)error);
            TaskExecutionState s2 = new TaskExecutionState(executionId, state, (Throwable)error);
            Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
            Assert.assertEquals((Object)s1, (Object)s2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerialization() {
        try {
            ExecutionAttemptID executionId = new ExecutionAttemptID();
            ExecutionState state = ExecutionState.DEPLOYING;
            IOException error = new IOException("fubar");
            TaskExecutionState original1 = new TaskExecutionState(executionId, state, (Throwable)error);
            TaskExecutionState original2 = new TaskExecutionState(executionId, state);
            TaskExecutionState javaSerCopy1 = (TaskExecutionState)CommonTestUtils.createCopySerializable((Serializable)original1);
            TaskExecutionState javaSerCopy2 = (TaskExecutionState)CommonTestUtils.createCopySerializable((Serializable)original2);
            Assert.assertEquals((Object)original1, (Object)javaSerCopy1);
            Assert.assertEquals((Object)javaSerCopy1, (Object)original1);
            Assert.assertEquals((Object)original2, (Object)javaSerCopy2);
            Assert.assertEquals((Object)javaSerCopy2, (Object)original2);
            Assert.assertEquals((long)original1.hashCode(), (long)javaSerCopy1.hashCode());
            Assert.assertEquals((long)original2.hashCode(), (long)javaSerCopy2.hashCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void handleNonSerializableException() {
        try {
            Exception hostile = new Exception(){

                @Override
                public String getMessage() {
                    throw new RuntimeException("Cannot get Message");
                }

                @Override
                public void printStackTrace(PrintStream s) {
                    throw new RuntimeException("Cannot print");
                }

                @Override
                public void printStackTrace(PrintWriter s) {
                    throw new RuntimeException("Cannot print");
                }
            };
            new TaskExecutionState(new ExecutionAttemptID(), ExecutionState.FAILED, (Throwable)hostile);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

