/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.PrioritizedOperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProvider;
import org.apache.flink.runtime.state.LocalRecoveryDirectoryProviderImpl;
import org.apache.flink.runtime.state.TaskLocalStateStore;
import org.apache.flink.runtime.state.TaskLocalStateStoreImpl;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.TaskStateManagerImpl;
import org.apache.flink.runtime.state.TestTaskLocalStateStore;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.inmemory.InMemoryStateChangelogStorage;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.TestCheckpointResponder;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TaskStateManagerImplTest
extends TestLogger {
    @Test
    public void testStateReportingAndRetrieving() {
        JobID jobID = new JobID();
        ExecutionAttemptID executionAttemptID = new ExecutionAttemptID();
        TestCheckpointResponder testCheckpointResponder = new TestCheckpointResponder();
        TestTaskLocalStateStore testTaskLocalStateStore = new TestTaskLocalStateStore();
        InMemoryStateChangelogStorage changelogStorage = new InMemoryStateChangelogStorage();
        TaskStateManager taskStateManager = TaskStateManagerImplTest.taskStateManager(jobID, executionAttemptID, testCheckpointResponder, null, testTaskLocalStateStore, changelogStorage);
        CheckpointMetaData checkpointMetaData = new CheckpointMetaData(74L, 11L);
        CheckpointMetrics checkpointMetrics = new CheckpointMetrics();
        TaskStateSnapshot jmTaskStateSnapshot = new TaskStateSnapshot();
        OperatorID operatorID_1 = new OperatorID(1L, 1L);
        OperatorID operatorID_2 = new OperatorID(2L, 2L);
        OperatorID operatorID_3 = new OperatorID(3L, 3L);
        Assert.assertFalse((boolean)taskStateManager.prioritizedOperatorState(operatorID_1).isRestored());
        Assert.assertFalse((boolean)taskStateManager.prioritizedOperatorState(operatorID_2).isRestored());
        Assert.assertFalse((boolean)taskStateManager.prioritizedOperatorState(operatorID_3).isRestored());
        KeyGroupRange keyGroupRange = new KeyGroupRange(0, 1);
        OperatorSubtaskState jmOperatorSubtaskState_1 = OperatorSubtaskState.builder().setManagedKeyedState(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange)).build();
        OperatorSubtaskState jmOperatorSubtaskState_2 = OperatorSubtaskState.builder().setRawKeyedState(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange)).build();
        jmTaskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, jmOperatorSubtaskState_1);
        jmTaskStateSnapshot.putSubtaskStateByOperatorID(operatorID_2, jmOperatorSubtaskState_2);
        TaskStateSnapshot tmTaskStateSnapshot = new TaskStateSnapshot();
        OperatorSubtaskState tmOperatorSubtaskState_1 = OperatorSubtaskState.builder().setManagedKeyedState(StateHandleDummyUtil.createNewKeyedStateHandle(keyGroupRange)).build();
        tmTaskStateSnapshot.putSubtaskStateByOperatorID(operatorID_1, tmOperatorSubtaskState_1);
        taskStateManager.reportTaskStateSnapshots(checkpointMetaData, checkpointMetrics, jmTaskStateSnapshot, tmTaskStateSnapshot);
        TestCheckpointResponder.AcknowledgeReport acknowledgeReport = testCheckpointResponder.getAcknowledgeReports().get(0);
        Assert.assertEquals((long)checkpointMetaData.getCheckpointId(), (long)acknowledgeReport.getCheckpointId());
        Assert.assertEquals((Object)checkpointMetrics, (Object)acknowledgeReport.getCheckpointMetrics());
        Assert.assertEquals((Object)executionAttemptID, (Object)acknowledgeReport.getExecutionAttemptID());
        Assert.assertEquals((Object)jobID, (Object)acknowledgeReport.getJobID());
        Assert.assertEquals((Object)jmTaskStateSnapshot, (Object)acknowledgeReport.getSubtaskState());
        Assert.assertEquals((Object)tmTaskStateSnapshot, (Object)testTaskLocalStateStore.retrieveLocalState(checkpointMetaData.getCheckpointId()));
        JobManagerTaskRestore taskRestore = new JobManagerTaskRestore(checkpointMetaData.getCheckpointId(), acknowledgeReport.getSubtaskState());
        taskStateManager = TaskStateManagerImplTest.taskStateManager(jobID, executionAttemptID, testCheckpointResponder, taskRestore, testTaskLocalStateStore, changelogStorage);
        PrioritizedOperatorSubtaskState prioritized_1 = taskStateManager.prioritizedOperatorState(operatorID_1);
        PrioritizedOperatorSubtaskState prioritized_2 = taskStateManager.prioritizedOperatorState(operatorID_2);
        PrioritizedOperatorSubtaskState prioritized_3 = taskStateManager.prioritizedOperatorState(operatorID_3);
        Assert.assertTrue((boolean)prioritized_1.isRestored());
        Assert.assertTrue((boolean)prioritized_2.isRestored());
        Assert.assertTrue((boolean)prioritized_3.isRestored());
        Assert.assertTrue((boolean)taskStateManager.prioritizedOperatorState(new OperatorID()).isRestored());
        Iterator prioritizedManagedKeyedState_1 = prioritized_1.getPrioritizedManagedKeyedState().iterator();
        Assert.assertTrue((boolean)prioritizedManagedKeyedState_1.hasNext());
        StateObjectCollection current = (StateObjectCollection)prioritizedManagedKeyedState_1.next();
        KeyedStateHandle keyedStateHandleExp = (KeyedStateHandle)tmOperatorSubtaskState_1.getManagedKeyedState().iterator().next();
        KeyedStateHandle keyedStateHandleAct = (KeyedStateHandle)current.iterator().next();
        Assert.assertTrue((keyedStateHandleExp == keyedStateHandleAct ? 1 : 0) != 0);
        Assert.assertTrue((boolean)prioritizedManagedKeyedState_1.hasNext());
        current = (StateObjectCollection)prioritizedManagedKeyedState_1.next();
        keyedStateHandleExp = (KeyedStateHandle)jmOperatorSubtaskState_1.getManagedKeyedState().iterator().next();
        keyedStateHandleAct = (KeyedStateHandle)current.iterator().next();
        Assert.assertTrue((keyedStateHandleExp == keyedStateHandleAct ? 1 : 0) != 0);
        Assert.assertFalse((boolean)prioritizedManagedKeyedState_1.hasNext());
        Iterator prioritizedRawKeyedState_2 = prioritized_2.getPrioritizedRawKeyedState().iterator();
        Assert.assertTrue((boolean)prioritizedRawKeyedState_2.hasNext());
        current = (StateObjectCollection)prioritizedRawKeyedState_2.next();
        keyedStateHandleExp = (KeyedStateHandle)jmOperatorSubtaskState_2.getRawKeyedState().iterator().next();
        keyedStateHandleAct = (KeyedStateHandle)current.iterator().next();
        Assert.assertTrue((keyedStateHandleExp == keyedStateHandleAct ? 1 : 0) != 0);
        Assert.assertFalse((boolean)prioritizedRawKeyedState_2.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForwardingSubtaskLocalStateBaseDirFromLocalStateStore() throws IOException {
        JobID jobID = new JobID(42L, 43L);
        AllocationID allocationID = new AllocationID(4711L, 23L);
        JobVertexID jobVertexID = new JobVertexID(12L, 34L);
        ExecutionAttemptID executionAttemptID = new ExecutionAttemptID();
        TestCheckpointResponder checkpointResponderMock = new TestCheckpointResponder();
        Executor directExecutor = Executors.directExecutor();
        TemporaryFolder tmpFolder = new TemporaryFolder();
        try {
            tmpFolder.create();
            File[] allocBaseDirs = new File[]{tmpFolder.newFolder(), tmpFolder.newFolder(), tmpFolder.newFolder()};
            LocalRecoveryDirectoryProviderImpl directoryProvider = new LocalRecoveryDirectoryProviderImpl(allocBaseDirs, jobID, jobVertexID, 0);
            LocalRecoveryConfig localRecoveryConfig = new LocalRecoveryConfig(true, (LocalRecoveryDirectoryProvider)directoryProvider);
            TaskLocalStateStoreImpl taskLocalStateStore = new TaskLocalStateStoreImpl(jobID, allocationID, jobVertexID, 13, localRecoveryConfig, directExecutor);
            InMemoryStateChangelogStorage changelogStorage = new InMemoryStateChangelogStorage();
            TaskStateManager taskStateManager = TaskStateManagerImplTest.taskStateManager(jobID, executionAttemptID, checkpointResponderMock, null, (TaskLocalStateStore)taskLocalStateStore, changelogStorage);
            LocalRecoveryConfig localRecoveryConfFromTaskLocalStateStore = taskLocalStateStore.getLocalRecoveryConfig();
            LocalRecoveryConfig localRecoveryConfFromTaskStateManager = taskStateManager.createLocalRecoveryConfig();
            for (int i = 0; i < 10; ++i) {
                Assert.assertEquals((Object)allocBaseDirs[i % allocBaseDirs.length], (Object)localRecoveryConfFromTaskLocalStateStore.getLocalStateDirectoryProvider().allocationBaseDirectory((long)i));
                Assert.assertEquals((Object)allocBaseDirs[i % allocBaseDirs.length], (Object)localRecoveryConfFromTaskStateManager.getLocalStateDirectoryProvider().allocationBaseDirectory((long)i));
            }
            Assert.assertEquals((Object)localRecoveryConfFromTaskLocalStateStore.isLocalRecoveryEnabled(), (Object)localRecoveryConfFromTaskStateManager.isLocalRecoveryEnabled());
        }
        finally {
            tmpFolder.delete();
        }
    }

    @Test
    public void testStateRetrievingWithFinishedOperator() {
        TaskStateSnapshot taskStateSnapshot = TaskStateSnapshot.FINISHED_ON_RESTORE;
        JobManagerTaskRestore jobManagerTaskRestore = new JobManagerTaskRestore(2L, taskStateSnapshot);
        TaskStateManagerImpl stateManager = new TaskStateManagerImpl(new JobID(), new ExecutionAttemptID(), (TaskLocalStateStore)new TestTaskLocalStateStore(), null, jobManagerTaskRestore, (CheckpointResponder)new TestCheckpointResponder());
        Assert.assertTrue((boolean)stateManager.isFinishedOnRestore());
    }

    public void testAcquringRestoreCheckpointId() {
        TaskStateManagerImpl emptyStateManager = new TaskStateManagerImpl(new JobID(), new ExecutionAttemptID(), (TaskLocalStateStore)new TestTaskLocalStateStore(), null, null, (CheckpointResponder)new TestCheckpointResponder());
        Assert.assertFalse((boolean)emptyStateManager.getRestoreCheckpointId().isPresent());
        TaskStateManagerImpl nonEmptyStateManager = new TaskStateManagerImpl(new JobID(), new ExecutionAttemptID(), (TaskLocalStateStore)new TestTaskLocalStateStore(), null, new JobManagerTaskRestore(2L, new TaskStateSnapshot()), (CheckpointResponder)new TestCheckpointResponder());
        Assert.assertEquals((long)2L, (long)((Long)nonEmptyStateManager.getRestoreCheckpointId().get()));
    }

    public static TaskStateManager taskStateManager(JobID jobID, ExecutionAttemptID executionAttemptID, CheckpointResponder checkpointResponderMock, JobManagerTaskRestore jobManagerTaskRestore, TaskLocalStateStore localStateStore, StateChangelogStorage<?> stateChangelogStorage) {
        return new TaskStateManagerImpl(jobID, executionAttemptID, localStateStore, stateChangelogStorage, jobManagerTaskRestore, checkpointResponderMock);
    }
}

