/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.cluster;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.cluster.JobManagerCustomLogHandler;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.UntypedResponseMessageHeaders;
import org.apache.flink.runtime.rest.messages.cluster.FileMessageParameters;
import org.apache.flink.runtime.rest.messages.cluster.JobManagerCustomLogHeaders;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JobManagerCustomLogHandlerTest
extends TestLogger {
    private static final String FORBIDDEN_FILENAME = "forbidden";
    private static final String VALID_LOG_FILENAME = "valid.log";
    private static final String VALID_LOG_CONTENT = "logged content";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File logRoot;
    private JobManagerCustomLogHandler testInstance;

    @Before
    public void setUp() throws IOException {
        this.initializeFolderStructure();
        TestingDispatcherGateway dispatcherGateway = new TestingDispatcherGateway.Builder().build();
        this.testInstance = new JobManagerCustomLogHandler(() -> CompletableFuture.completedFuture(dispatcherGateway), TestingUtils.TIMEOUT, Collections.emptyMap(), (UntypedResponseMessageHeaders)JobManagerCustomLogHeaders.getInstance(), this.logRoot);
    }

    private void initializeFolderStructure() throws IOException {
        File root = this.temporaryFolder.getRoot();
        this.logRoot = new File(root, "logs");
        Assert.assertTrue((boolean)this.logRoot.mkdir());
        JobManagerCustomLogHandlerTest.createFile(new File(root, FORBIDDEN_FILENAME), "forbidden content");
        JobManagerCustomLogHandlerTest.createFile(new File(this.logRoot, VALID_LOG_FILENAME), VALID_LOG_CONTENT);
    }

    private static void createFile(File file, String content) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
    }

    private static HandlerRequest<EmptyRequestBody, FileMessageParameters> createHandlerRequest(String path) throws HandlerRequestException {
        FileMessageParameters messageParameters = new FileMessageParameters();
        HashMap<String, String> pathParameters = new HashMap<String, String>();
        pathParameters.put(messageParameters.logFileNamePathParameter.getKey(), path);
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)messageParameters, pathParameters, Collections.emptyMap());
    }

    @Test
    public void testGetJobManagerCustomLogsValidFilename() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(VALID_LOG_FILENAME));
        Assert.assertThat((Object)actualFile, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assert.assertThat((Object)actualContent, (Matcher)Matchers.is((Object)VALID_LOG_CONTENT));
    }

    @Test
    public void testGetJobManagerCustomLogsValidFilenameWithPath() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("foobar/%s", VALID_LOG_FILENAME)));
        Assert.assertThat((Object)actualFile, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assert.assertThat((Object)actualContent, (Matcher)Matchers.is((Object)VALID_LOG_CONTENT));
    }

    @Test
    public void testGetJobManagerCustomLogsValidFilenameWithInvalidPath() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("../%s", VALID_LOG_FILENAME)));
        Assert.assertThat((Object)actualFile, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assert.assertThat((Object)actualContent, (Matcher)Matchers.is((Object)VALID_LOG_CONTENT));
    }

    @Test
    public void testGetJobManagerCustomLogsNotExistingFile() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest("not-existing"));
        Assert.assertThat((Object)actualFile, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertFalse((boolean)actualFile.exists());
    }

    @Test
    public void testGetJobManagerCustomLogsExistingButForbiddenFile() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("../%s", FORBIDDEN_FILENAME)));
        Assert.assertThat((Object)actualFile, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertFalse((boolean)actualFile.exists());
    }

    @Test
    public void testGetJobManagerCustomLogsValidFilenameWithLongInvalidPath() throws Exception {
        File actualFile = this.testInstance.getFile(JobManagerCustomLogHandlerTest.createHandlerRequest(String.format("foobar/../../%s", VALID_LOG_FILENAME)));
        Assert.assertThat((Object)actualFile, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        String actualContent = String.join((CharSequence)"", Files.readAllLines(actualFile.toPath()));
        Assert.assertThat((Object)actualContent, (Matcher)Matchers.is((Object)VALID_LOG_CONTENT));
    }
}

