/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationKey;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.util.ManualTicker;
import org.apache.flink.shaded.guava30.com.google.common.base.Ticker;
import org.apache.flink.types.Either;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompletedOperationCacheTest
extends TestLogger {
    private static final OperationKey TEST_OPERATION_KEY = new OperationKey(new TriggerId());
    private static final CompletableFuture<String> TEST_OPERATION_RESULT = CompletableFuture.completedFuture("foo");
    private ManualTicker manualTicker;
    private CompletedOperationCache<OperationKey, String> completedOperationCache;

    @Before
    public void setUp() {
        this.manualTicker = new ManualTicker();
        this.completedOperationCache = new CompletedOperationCache((Ticker)this.manualTicker);
    }

    @Test
    public void testShouldFinishClosingCacheIfAllResultsAreEvicted() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        CompletableFuture closeCacheFuture = this.completedOperationCache.closeAsync();
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)false));
        this.manualTicker.advanceTime(300L, TimeUnit.SECONDS);
        this.completedOperationCache.cleanUp();
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testShouldFinishClosingCacheIfAllResultsAccessed() throws Exception {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        CompletableFuture closeCacheFuture = this.completedOperationCache.closeAsync();
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)false));
        Either operationResultOrError = this.completedOperationCache.get(TEST_OPERATION_KEY);
        Assert.assertThat((Object)operationResultOrError, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)operationResultOrError.right(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_OPERATION_RESULT.get())));
        Assert.assertThat((Object)closeCacheFuture.isDone(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testCannotAddOperationAfterClosing() {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, new CompletableFuture());
        CompletableFuture terminationFuture = this.completedOperationCache.closeAsync();
        Assert.assertFalse((boolean)terminationFuture.isDone());
        try {
            this.completedOperationCache.registerOngoingOperation(new OperationKey(new TriggerId()), new CompletableFuture());
            Assert.fail((String)"It should no longer be possible to register new operations because the cache is shutting down.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testCanGetOperationResultAfterClosing() throws Exception {
        this.completedOperationCache.registerOngoingOperation(TEST_OPERATION_KEY, TEST_OPERATION_RESULT);
        this.completedOperationCache.closeAsync();
        Either result = this.completedOperationCache.get(TEST_OPERATION_KEY);
        Assert.assertThat((Object)result.right(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)TEST_OPERATION_RESULT.get())));
    }
}

