/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.resourcemanager.active.ResourceEventHandler;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.TriFunctionWithException;

public class TestingResourceManagerDriver
implements ResourceManagerDriver<ResourceID> {
    private final TriFunctionWithException<ResourceEventHandler<ResourceID>, ScheduledExecutor, Executor, Void, Exception> initializeFunction;
    private final BiConsumerWithException<ApplicationStatus, String, Exception> deregisterApplicationConsumer;
    private final Function<TaskExecutorProcessSpec, CompletableFuture<ResourceID>> requestResourceFunction;
    private final Consumer<ResourceID> releaseResourceConsumer;

    private TestingResourceManagerDriver(TriFunctionWithException<ResourceEventHandler<ResourceID>, ScheduledExecutor, Executor, Void, Exception> initializeFunction, BiConsumerWithException<ApplicationStatus, String, Exception> deregisterApplicationConsumer, Function<TaskExecutorProcessSpec, CompletableFuture<ResourceID>> requestResourceFunction, Consumer<ResourceID> releaseResourceConsumer) {
        this.initializeFunction = (TriFunctionWithException)Preconditions.checkNotNull(initializeFunction);
        this.deregisterApplicationConsumer = (BiConsumerWithException)Preconditions.checkNotNull(deregisterApplicationConsumer);
        this.requestResourceFunction = (Function)Preconditions.checkNotNull(requestResourceFunction);
        this.releaseResourceConsumer = (Consumer)Preconditions.checkNotNull(releaseResourceConsumer);
    }

    public void initialize(ResourceEventHandler<ResourceID> resourceEventHandler, ScheduledExecutor mainThreadExecutor, Executor ioExecutor) throws Exception {
        this.initializeFunction.apply(resourceEventHandler, (Object)mainThreadExecutor, (Object)ioExecutor);
    }

    public void terminate() {
    }

    public void deregisterApplication(ApplicationStatus finalStatus, @Nullable String optionalDiagnostics) throws Exception {
        this.deregisterApplicationConsumer.accept((Object)finalStatus, (Object)optionalDiagnostics);
    }

    public CompletableFuture<ResourceID> requestResource(TaskExecutorProcessSpec taskExecutorProcessSpec) {
        return this.requestResourceFunction.apply(taskExecutorProcessSpec);
    }

    public void releaseResource(ResourceID worker) {
        this.releaseResourceConsumer.accept(worker);
    }

    public static class Builder {
        private TriFunctionWithException<ResourceEventHandler<ResourceID>, ScheduledExecutor, Executor, Void, Exception> initializeFunction = (ignore1, ignore2, ignore3) -> null;
        private BiConsumerWithException<ApplicationStatus, String, Exception> deregisterApplicationConsumer = (ignore1, ignore2) -> {};
        private Function<TaskExecutorProcessSpec, CompletableFuture<ResourceID>> requestResourceFunction = ignore -> CompletableFuture.completedFuture(ResourceID.generate());
        private Consumer<ResourceID> releaseResourceConsumer = ignore -> {};

        public Builder setInitializeFunction(TriFunctionWithException<ResourceEventHandler<ResourceID>, ScheduledExecutor, Executor, Void, Exception> initializeFunction) {
            this.initializeFunction = (TriFunctionWithException)Preconditions.checkNotNull(initializeFunction);
            return this;
        }

        public Builder setDeregisterApplicationConsumer(BiConsumerWithException<ApplicationStatus, String, Exception> deregisterApplicationConsumer) {
            this.deregisterApplicationConsumer = (BiConsumerWithException)Preconditions.checkNotNull(deregisterApplicationConsumer);
            return this;
        }

        public Builder setRequestResourceFunction(Function<TaskExecutorProcessSpec, CompletableFuture<ResourceID>> requestResourceFunction) {
            this.requestResourceFunction = (Function)Preconditions.checkNotNull(requestResourceFunction);
            return this;
        }

        public Builder setReleaseResourceConsumer(Consumer<ResourceID> releaseResourceConsumer) {
            this.releaseResourceConsumer = (Consumer)Preconditions.checkNotNull(releaseResourceConsumer);
            return this;
        }

        public TestingResourceManagerDriver build() {
            return new TestingResourceManagerDriver(this.initializeFunction, this.deregisterApplicationConsumer, this.requestResourceFunction, this.releaseResourceConsumer);
        }
    }
}

