/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.PartitionRequestClient;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelBuilder;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGateBuilder;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class InputChannelTestUtils {
    public static ResultPartitionManager createResultPartitionManager(final ResultSubpartition[] sources) throws Exception {
        Answer<ResultSubpartitionView> viewCreator = new Answer<ResultSubpartitionView>(){
            private int num = 0;

            public ResultSubpartitionView answer(InvocationOnMock invocation) throws Throwable {
                BufferAvailabilityListener channel = (BufferAvailabilityListener)invocation.getArguments()[2];
                return sources[this.num++].createReadView(channel);
            }
        };
        ResultPartitionManager manager = (ResultPartitionManager)Mockito.mock(ResultPartitionManager.class);
        Mockito.when((Object)manager.createSubpartitionView((ResultPartitionID)Matchers.any(ResultPartitionID.class), Matchers.anyInt(), (BufferAvailabilityListener)Matchers.any(BufferAvailabilityListener.class))).thenAnswer((Answer)viewCreator);
        return manager;
    }

    public static SingleInputGate createSingleInputGate(int numberOfChannels) {
        return new SingleInputGateBuilder().setNumberOfChannels(numberOfChannels).build();
    }

    public static SingleInputGate createSingleInputGate(BufferPool bufferPool) {
        return new SingleInputGateBuilder().setNumberOfChannels(2).setBufferPoolFactory(bufferPool).build();
    }

    public static SingleInputGate createSingleInputGate(int numberOfChannels, MemorySegmentProvider segmentProvider) {
        return new SingleInputGateBuilder().setNumberOfChannels(numberOfChannels).setSegmentProvider(segmentProvider).build();
    }

    public static ConnectionManager createDummyConnectionManager() throws Exception {
        PartitionRequestClient mockClient = (PartitionRequestClient)Mockito.mock(PartitionRequestClient.class);
        ConnectionManager connManager = (ConnectionManager)Mockito.mock(ConnectionManager.class);
        Mockito.when((Object)connManager.createPartitionRequestClient((ConnectionID)Matchers.any(ConnectionID.class))).thenReturn((Object)mockClient);
        return connManager;
    }

    public static LocalInputChannel createLocalInputChannel(SingleInputGate inputGate, ResultPartitionManager partitionManager) {
        return InputChannelTestUtils.createLocalInputChannel(inputGate, partitionManager, 0, 0);
    }

    public static LocalInputChannel createLocalInputChannel(SingleInputGate inputGate, ResultPartitionManager partitionManager, int initialBackoff, int maxBackoff) {
        return InputChannelTestUtils.createLocalInputChannel(inputGate, partitionManager, initialBackoff, maxBackoff, unused -> {});
    }

    public static LocalInputChannel createLocalInputChannel(SingleInputGate inputGate, ResultPartitionManager partitionManager, int initialBackoff, int maxBackoff, Consumer<InputChannelBuilder> setter) {
        InputChannelBuilder inputChannelBuilder = InputChannelBuilder.newBuilder().setPartitionManager(partitionManager).setInitialBackoff(initialBackoff).setMaxBackoff(maxBackoff);
        setter.accept(inputChannelBuilder);
        return inputChannelBuilder.buildLocalChannel(inputGate);
    }

    public static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, int channelIndex, ConnectionManager connectionManager) {
        return InputChannelBuilder.newBuilder().setChannelIndex(channelIndex).setConnectionManager(connectionManager).buildRemoteChannel(inputGate);
    }

    public static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, PartitionRequestClient client) {
        return InputChannelBuilder.newBuilder().setConnectionManager(InputChannelTestUtils.mockConnectionManagerWithPartitionRequestClient(client)).buildRemoteChannel(inputGate);
    }

    public static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, int numExclusiveSegments) {
        return InputChannelBuilder.newBuilder().setNetworkBuffersPerChannel(numExclusiveSegments).buildRemoteChannel(inputGate);
    }

    public static RemoteInputChannel createRemoteInputChannel(SingleInputGate inputGate, PartitionRequestClient client, int numExclusiveSegments) {
        return InputChannelBuilder.newBuilder().setConnectionManager(InputChannelTestUtils.mockConnectionManagerWithPartitionRequestClient(client)).setNetworkBuffersPerChannel(numExclusiveSegments).buildRemoteChannel(inputGate);
    }

    public static ConnectionManager mockConnectionManagerWithPartitionRequestClient(final PartitionRequestClient client) {
        return new ConnectionManager(){

            public int start() {
                return -1;
            }

            public PartitionRequestClient createPartitionRequestClient(ConnectionID connectionId) {
                return client;
            }

            public void closeOpenChannelConnections(ConnectionID connectionId) {
            }

            public int getNumberOfActiveConnections() {
                return 0;
            }

            public void shutdown() {
            }
        };
    }

    public static InputChannelMetrics newUnregisteredInputChannelMetrics() {
        return new InputChannelMetrics(new MetricGroup[]{UnregisteredMetricGroups.createUnregisteredTaskMetricGroup().getIOMetricGroup()});
    }

    private InputChannelTestUtils() {
    }

    public static class UnpooledMemorySegmentProvider
    implements MemorySegmentProvider {
        private final int pageSize;

        public UnpooledMemorySegmentProvider(int pageSize) {
            this.pageSize = pageSize;
        }

        public Collection<MemorySegment> requestMemorySegments(int numberOfSegmentsToRequest) {
            return Collections.singletonList(MemorySegmentFactory.allocateUnpooledSegment((int)this.pageSize));
        }

        public void recycleMemorySegments(Collection<MemorySegment> segments) {
        }
    }

    public static class StubMemorySegmentProvider
    implements MemorySegmentProvider {
        private static final MemorySegmentProvider INSTANCE = new StubMemorySegmentProvider();

        public static MemorySegmentProvider getInstance() {
            return INSTANCE;
        }

        private StubMemorySegmentProvider() {
        }

        public Collection<MemorySegment> requestMemorySegments(int numberOfSegmentsToRequest) {
            return Collections.emptyList();
        }

        public void recycleMemorySegments(Collection<MemorySegment> segments) {
        }
    }
}

