/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.zookeeper;

import org.apache.curator.test.TestingServer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.zookeeper.ZooKeeperHaServices;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZooKeeperRegistryTest
extends TestLogger {
    private TestingServer testingServer;

    @Before
    public void before() throws Exception {
        this.testingServer = new TestingServer();
    }

    @After
    public void after() throws Exception {
        this.testingServer.stop();
        this.testingServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZooKeeperRegistry() throws Exception {
        Configuration configuration = new Configuration();
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, this.testingServer.getConnectString());
        configuration.setString(HighAvailabilityOptions.HA_MODE, "zookeeper");
        CuratorFramework zkClient = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
        ZooKeeperHaServices zkHaService = new ZooKeeperHaServices(zkClient, Executors.directExecutor(), configuration, (BlobStoreService)new VoidBlobStore());
        RunningJobsRegistry zkRegistry = zkHaService.getRunningJobsRegistry();
        try {
            JobID jobID = JobID.generate();
            Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.PENDING, (Object)zkRegistry.getJobSchedulingStatus(jobID));
            zkRegistry.setJobRunning(jobID);
            Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.RUNNING, (Object)zkRegistry.getJobSchedulingStatus(jobID));
            zkRegistry.setJobFinished(jobID);
            Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.DONE, (Object)zkRegistry.getJobSchedulingStatus(jobID));
            zkRegistry.clearJob(jobID);
            Assert.assertEquals((Object)RunningJobsRegistry.JobSchedulingStatus.PENDING, (Object)zkRegistry.getJobSchedulingStatus(jobID));
            zkRegistry.clearJob(jobID);
        }
        finally {
            zkHaService.closeAndCleanupAllData();
        }
    }
}

