/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.JobManagerRunnerFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.TestingJobManagerRunner;
import org.apache.flink.runtime.jobmaster.factories.JobManagerJobMetricGroupFactory;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.Preconditions;

public class TestingJobManagerRunnerFactory
implements JobManagerRunnerFactory {
    private final BlockingQueue<TestingJobManagerRunner> createdJobManagerRunner = new ArrayBlockingQueue<TestingJobManagerRunner>(16);
    private final AtomicInteger numBlockingJobManagerRunners;

    public TestingJobManagerRunnerFactory() {
        this(0);
    }

    public TestingJobManagerRunnerFactory(int numBlockingJobManagerRunners) {
        this.numBlockingJobManagerRunners = new AtomicInteger(numBlockingJobManagerRunners);
    }

    public TestingJobManagerRunner createJobManagerRunner(JobGraph jobGraph, Configuration configuration, RpcService rpcService, HighAvailabilityServices highAvailabilityServices, HeartbeatServices heartbeatServices, JobManagerSharedServices jobManagerServices, JobManagerJobMetricGroupFactory jobManagerJobMetricGroupFactory, FatalErrorHandler fatalErrorHandler, long initializationTimestamp) throws Exception {
        TestingJobManagerRunner testingJobManagerRunner = this.createTestingJobManagerRunner(jobGraph);
        Preconditions.checkState((boolean)this.createdJobManagerRunner.offer(testingJobManagerRunner), (Object)"Unable to persist created the new runner.");
        return testingJobManagerRunner;
    }

    @Nonnull
    private TestingJobManagerRunner createTestingJobManagerRunner(JobGraph jobGraph) {
        boolean blockingTermination = this.numBlockingJobManagerRunners.getAndDecrement() > 0;
        return TestingJobManagerRunner.newBuilder().setJobId(jobGraph.getJobID()).setBlockingTermination(blockingTermination).build();
    }

    public TestingJobManagerRunner takeCreatedJobManagerRunner() throws InterruptedException {
        return this.createdJobManagerRunner.take();
    }
}

