/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.utils;

import java.io.File;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.Prio0InboundChannelHandlerFactory;
import org.apache.flink.runtime.io.network.netty.Prio1InboundChannelHandlerFactory;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.webmonitor.history.HistoryServerStaticFileServerHandler;
import org.apache.flink.runtime.webmonitor.history.HistoryServerTest;
import org.apache.flink.runtime.webmonitor.utils.WebFrontendBootstrap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.LoggerFactory;

public class WebFrontendBootstrapTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHandlersMustBeLoaded() throws Exception {
        File webDir = this.tmp.newFolder("webDir");
        Configuration configuration = new Configuration();
        configuration.setString(Prio0InboundChannelHandlerFactory.REDIRECT_FROM_URL, "/nonExisting");
        configuration.setString(Prio0InboundChannelHandlerFactory.REDIRECT_TO_URL, "/index.html");
        Router router = new Router().addGet("/:*", (Object)new HistoryServerStaticFileServerHandler(webDir));
        WebFrontendBootstrap webUI = new WebFrontendBootstrap(router, LoggerFactory.getLogger(WebFrontendBootstrapTest.class), this.tmp.newFolder("uploadDir"), null, "localhost", 0, configuration);
        Assert.assertEquals((long)webUI.inboundChannelHandlerFactories.size(), (long)2L);
        Assert.assertTrue((boolean)(webUI.inboundChannelHandlerFactories.get(0) instanceof Prio1InboundChannelHandlerFactory));
        Assert.assertTrue((boolean)(webUI.inboundChannelHandlerFactories.get(1) instanceof Prio0InboundChannelHandlerFactory));
        int port = webUI.getServerPort();
        try {
            Tuple2<Integer, String> index = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/index.html");
            Assert.assertEquals((long)((Integer)index.f0).intValue(), (long)200L);
            Assert.assertTrue((boolean)((String)index.f1).contains("Apache Flink Web Dashboard"));
            Tuple2<Integer, String> index2 = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/nonExisting");
            Assert.assertEquals((long)((Integer)index2.f0).intValue(), (long)200L);
            Assert.assertEquals(index, index2);
        }
        finally {
            webUI.shutdown();
        }
    }
}

