/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.io.File;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.webmonitor.history.HistoryServerStaticFileServerHandler;
import org.apache.flink.runtime.webmonitor.history.HistoryServerTest;
import org.apache.flink.runtime.webmonitor.utils.WebFrontendBootstrap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.LoggerFactory;

public class HistoryServerStaticFileServerHandlerTest
extends TestLogger {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRespondWithFile() throws Exception {
        File webDir = this.tmp.newFolder("webDir");
        Router router = new Router().addGet("/:*", (Object)new HistoryServerStaticFileServerHandler(webDir));
        WebFrontendBootstrap webUI = new WebFrontendBootstrap(router, LoggerFactory.getLogger(HistoryServerStaticFileServerHandlerTest.class), this.tmp.newFolder("uploadDir"), null, "localhost", 0, new Configuration());
        int port = webUI.getServerPort();
        try {
            Tuple2<Integer, String> notFound404 = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/hello");
            Assert.assertThat((Object)notFound404.f0, (Matcher)Is.is((Object)404));
            Assert.assertThat((Object)notFound404.f1, (Matcher)CoreMatchers.containsString((String)"not found"));
            Tuple2<Integer, String> index = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/index.html");
            Assert.assertThat((Object)index.f0, (Matcher)Is.is((Object)200));
            Assert.assertThat((Object)index.f1, (Matcher)CoreMatchers.containsString((String)"Apache Flink Web Dashboard"));
            Tuple2<Integer, String> index2 = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/");
            Assert.assertEquals(index, index2);
            File dir = new File(webDir, "dir.json");
            dir.mkdirs();
            Tuple2<Integer, String> dirNotFound = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/dir");
            Assert.assertThat((Object)dirNotFound.f0, (Matcher)Is.is((Object)405));
            Assert.assertThat((Object)dirNotFound.f1, (Matcher)CoreMatchers.containsString((String)"not found"));
            this.tmp.newFile("secret");
            Tuple2<Integer, String> dirOutsideDirectory = HistoryServerTest.getFromHTTP("http://localhost:" + port + "/../secret");
            Assert.assertThat((Object)dirOutsideDirectory.f0, (Matcher)Is.is((Object)403));
            Assert.assertThat((Object)dirOutsideDirectory.f1, (Matcher)CoreMatchers.containsString((String)"Forbidden"));
        }
        finally {
            webUI.shutdown();
        }
    }
}

