/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.history;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.history.FsJobArchivist;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FsJobArchivistTest {
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testArchiveJob() throws Exception {
        Path tmpPath = new Path(this.tmpFolder.getRoot().getAbsolutePath());
        JobID jobId = new JobID();
        ArrayList<ArchivedJson> toArchive = new ArrayList<ArchivedJson>(2);
        toArchive.add(new ArchivedJson("dir1", "hello"));
        toArchive.add(new ArchivedJson("dir1/dir11", "world"));
        Path archive = FsJobArchivist.archiveJob((Path)tmpPath, (JobID)jobId, toArchive);
        Collection restored = FsJobArchivist.getArchivedJsons((Path)archive);
        Assert.assertThat((Object)restored, (Matcher)Matchers.containsInAnyOrder((Object[])toArchive.toArray()));
    }
}

