/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers.utils;

import java.util.List;
import org.apache.flink.runtime.webmonitor.handlers.utils.JarHandlerUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class JarHandlerUtilsTest
extends TestLogger {
    @Test
    public void testTokenizeNonQuoted() {
        List arguments = JarHandlerUtils.tokenizeArguments((String)"--foo bar");
        Assert.assertThat(arguments.get(0), (Matcher)Matchers.equalTo((Object)"--foo"));
        Assert.assertThat(arguments.get(1), (Matcher)Matchers.equalTo((Object)"bar"));
    }

    @Test
    public void testTokenizeSingleQuoted() {
        List arguments = JarHandlerUtils.tokenizeArguments((String)"--foo 'bar baz '");
        Assert.assertThat(arguments.get(0), (Matcher)Matchers.equalTo((Object)"--foo"));
        Assert.assertThat(arguments.get(1), (Matcher)Matchers.equalTo((Object)"bar baz "));
    }

    @Test
    public void testTokenizeDoubleQuoted() {
        List arguments = JarHandlerUtils.tokenizeArguments((String)"--name \"K. Bote \"");
        Assert.assertThat(arguments.get(0), (Matcher)Matchers.equalTo((Object)"--name"));
        Assert.assertThat(arguments.get(1), (Matcher)Matchers.equalTo((Object)"K. Bote "));
    }
}

