/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadResponseBody;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class JarUploadHandlerTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private JarUploadHandler jarUploadHandler;
    @Mock
    private DispatcherGateway mockDispatcherGateway;
    private Path jarDir;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.jarDir = this.temporaryFolder.newFolder().toPath();
        this.jarUploadHandler = new JarUploadHandler(() -> CompletableFuture.completedFuture(this.mockDispatcherGateway), Time.seconds((long)10L), Collections.emptyMap(), (MessageHeaders)JarUploadHeaders.getInstance(), this.jarDir, Executors.directExecutor());
    }

    @Test
    public void testRejectNonJarFiles() throws Exception {
        Path uploadedFile = Files.createFile(this.jarDir.resolve("katrin.png"), new FileAttribute[0]);
        HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request = JarUploadHandlerTest.createRequest(uploadedFile);
        try {
            this.jarUploadHandler.handleRequest(request, (RestfulGateway)this.mockDispatcherGateway).get();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (ExecutionException e) {
            Throwable throwable = ExceptionUtils.stripCompletionException((Throwable)e.getCause());
            Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(RestHandlerException.class));
            RestHandlerException restHandlerException = (RestHandlerException)throwable;
            Assert.assertThat((Object)restHandlerException.getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.BAD_REQUEST));
        }
    }

    @Test
    public void testUploadJar() throws Exception {
        Path uploadedFile = Files.createFile(this.jarDir.resolve("FooBazzleExample.jar"), new FileAttribute[0]);
        HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request = JarUploadHandlerTest.createRequest(uploadedFile);
        JarUploadResponseBody jarUploadResponseBody = (JarUploadResponseBody)this.jarUploadHandler.handleRequest(request, (RestfulGateway)this.mockDispatcherGateway).get();
        Assert.assertThat((Object)jarUploadResponseBody.getStatus(), (Matcher)Matchers.equalTo((Object)JarUploadResponseBody.UploadStatus.success));
        String returnedFileNameWithUUID = jarUploadResponseBody.getFilename();
        Assert.assertThat((Object)returnedFileNameWithUUID, (Matcher)Matchers.containsString((String)"_"));
        String returnedFileName = returnedFileNameWithUUID.substring(returnedFileNameWithUUID.lastIndexOf("_") + 1);
        Assert.assertThat((Object)returnedFileName, (Matcher)Matchers.equalTo((Object)uploadedFile.getFileName().toString()));
    }

    @Test
    public void testFailedUpload() throws Exception {
        Path uploadedFile = this.jarDir.resolve("FooBazzleExample.jar");
        HandlerRequest<EmptyRequestBody, EmptyMessageParameters> request = JarUploadHandlerTest.createRequest(uploadedFile);
        try {
            this.jarUploadHandler.handleRequest(request, (RestfulGateway)this.mockDispatcherGateway).get();
            Assert.fail((String)"Expected exception not thrown.");
        }
        catch (ExecutionException e) {
            Throwable throwable = ExceptionUtils.stripCompletionException((Throwable)e.getCause());
            Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(RestHandlerException.class));
            RestHandlerException restHandlerException = (RestHandlerException)throwable;
            Assert.assertThat((Object)restHandlerException.getMessage(), (Matcher)Matchers.containsString((String)"Could not move uploaded jar file"));
            Assert.assertThat((Object)restHandlerException.getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR));
        }
    }

    private static HandlerRequest<EmptyRequestBody, EmptyMessageParameters> createRequest(Path uploadedFile) throws HandlerRequestException, IOException {
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance(), Collections.emptyMap(), Collections.emptyMap(), Collections.singleton(uploadedFile.toFile()));
    }
}

