/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.util.BlobServerResource;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarHandlers;
import org.apache.flink.runtime.webmonitor.handlers.JarListHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarListInfo;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHandler;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JarSubmissionITCase
extends TestLogger {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final BlobServerResource blobServerResource = new BlobServerResource();

    @Test
    public void testJarSubmission() throws Exception {
        TestingDispatcherGateway restfulGateway = new TestingDispatcherGateway.Builder().setBlobServerPort(this.blobServerResource.getBlobServerPort()).setSubmitFunction(jobGraph -> CompletableFuture.completedFuture(Acknowledge.get())).build();
        JarHandlers handlers = new JarHandlers(this.temporaryFolder.newFolder().toPath(), restfulGateway);
        JarUploadHandler uploadHandler = handlers.uploadHandler;
        JarListHandler listHandler = handlers.listHandler;
        JarPlanHandler planHandler = handlers.planHandler;
        JarRunHandler runHandler = handlers.runHandler;
        JarDeleteHandler deleteHandler = handlers.deleteHandler;
        Path originalJar = Paths.get(System.getProperty("targetDir"), new String[0]).resolve("test-program.jar");
        Path jar = Files.copy(originalJar, this.temporaryFolder.getRoot().toPath().resolve("test-program.jar"), new CopyOption[0]);
        String storedJarPath = JarHandlers.uploadJar(uploadHandler, jar, (RestfulGateway)restfulGateway);
        String storedJarName = Paths.get(storedJarPath, new String[0]).getFileName().toString();
        JarListInfo postUploadListResponse = JarHandlers.listJars(listHandler, (RestfulGateway)restfulGateway);
        Assert.assertEquals((long)1L, (long)postUploadListResponse.jarFileList.size());
        JarListInfo.JarFileInfo listEntry = (JarListInfo.JarFileInfo)postUploadListResponse.jarFileList.iterator().next();
        Assert.assertEquals((Object)jar.getFileName().toString(), (Object)listEntry.name);
        Assert.assertEquals((Object)storedJarName, (Object)listEntry.id);
        JobPlanInfo planResponse = JarHandlers.showPlan(planHandler, storedJarName, (RestfulGateway)restfulGateway);
        Assert.assertThat((Object)planResponse.getJsonPlan(), (Matcher)Matchers.containsString((String)"TestProgram.java:28"));
        JarHandlers.runJar(runHandler, storedJarName, (DispatcherGateway)restfulGateway);
        JarHandlers.deleteJar(deleteHandler, storedJarName, (RestfulGateway)restfulGateway);
        JarListInfo postDeleteListResponse = JarHandlers.listJars(listHandler, (RestfulGateway)restfulGateway);
        Assert.assertEquals((long)0L, (long)postDeleteListResponse.jarFileList.size());
    }
}

