/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.deployment.application.DetachedApplicationRunner;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.runtime.webmonitor.handlers.JarHandlerParameterTest;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarRunMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.testutils.ParameterProgram;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JarRunHandlerParameterTest
extends JarHandlerParameterTest<JarRunRequestBody, JarRunMessageParameters> {
    private static final boolean ALLOW_NON_RESTORED_STATE_QUERY = true;
    private static final String RESTORE_PATH = "/foo/bar";
    private static JarRunHandler handler;
    private static Path jarWithEagerSink;

    @BeforeClass
    public static void setup() throws Exception {
        JarRunHandlerParameterTest.init();
        GatewayRetriever gatewayRetriever = () -> CompletableFuture.completedFuture(restfulGateway);
        Time timeout = Time.seconds((long)10L);
        Map responseHeaders = Collections.emptyMap();
        ScheduledExecutorService executor = TestingUtils.defaultExecutor();
        Path jarLocation = Paths.get(System.getProperty("targetDir"), new String[0]);
        String parameterProgramWithEagerSink = "parameter-program-with-eager-sink.jar";
        jarWithEagerSink = Files.copy(jarLocation.resolve("parameter-program-with-eager-sink.jar"), jarDir.resolve("program-with-eager-sink.jar"), new CopyOption[0]);
        handler = new JarRunHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarRunHeaders.getInstance(), jarDir, new Configuration(), (Executor)executor, ConfigurationVerifyingDetachedApplicationRunner::new);
    }

    @Override
    JarRunMessageParameters getUnresolvedJarMessageParameters() {
        return (JarRunMessageParameters)handler.getMessageHeaders().getUnresolvedMessageParameters();
    }

    @Override
    JarRunMessageParameters getJarMessageParameters(JarHandlerParameterTest.ProgramArgsParType programArgsParType) {
        JarRunMessageParameters parameters = this.getUnresolvedJarMessageParameters();
        parameters.allowNonRestoredStateQueryParameter.resolve(Collections.singletonList(true));
        parameters.savepointPathQueryParameter.resolve(Collections.singletonList(RESTORE_PATH));
        parameters.entryClassQueryParameter.resolve(Collections.singletonList(ParameterProgram.class.getCanonicalName()));
        parameters.parallelismQueryParameter.resolve(Collections.singletonList(4));
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.String || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgsQueryParameter.resolve(Collections.singletonList(String.join((CharSequence)" ", PROG_ARGS)));
        }
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.List || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgQueryParameter.resolve(Arrays.asList(PROG_ARGS));
        }
        return parameters;
    }

    @Override
    JarRunMessageParameters getWrongJarMessageParameters(JarHandlerParameterTest.ProgramArgsParType programArgsParType) {
        List wrongArgs = Arrays.stream(PROG_ARGS).map(a -> a + "wrong").collect(Collectors.toList());
        String argsWrongStr = String.join((CharSequence)" ", wrongArgs);
        JarRunMessageParameters parameters = this.getUnresolvedJarMessageParameters();
        parameters.allowNonRestoredStateQueryParameter.resolve(Collections.singletonList(false));
        parameters.savepointPathQueryParameter.resolve(Collections.singletonList("/no/uh"));
        parameters.entryClassQueryParameter.resolve(Collections.singletonList("please.dont.run.me"));
        parameters.parallelismQueryParameter.resolve(Collections.singletonList(64));
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.String || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgsQueryParameter.resolve(Collections.singletonList(argsWrongStr));
        }
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.List || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgQueryParameter.resolve(wrongArgs);
        }
        return parameters;
    }

    @Override
    JarRunRequestBody getDefaultJarRequestBody() {
        return new JarRunRequestBody();
    }

    @Override
    JarRunRequestBody getJarRequestBody(JarHandlerParameterTest.ProgramArgsParType programArgsParType) {
        return new JarRunRequestBody(ParameterProgram.class.getCanonicalName(), JarRunHandlerParameterTest.getProgramArgsString(programArgsParType), JarRunHandlerParameterTest.getProgramArgsList(programArgsParType), Integer.valueOf(4), null, Boolean.valueOf(true), RESTORE_PATH);
    }

    @Override
    JarRunRequestBody getJarRequestBodyWithJobId(JobID jobId) {
        return new JarRunRequestBody(null, null, null, null, jobId, null, null);
    }

    @Test
    public void testRestHandlerExceptionThrownWithEagerSinks() throws Exception {
        HandlerRequest<JarRunRequestBody, JarRunMessageParameters> request = JarRunHandlerParameterTest.createRequest(this.getDefaultJarRequestBody(), this.getUnresolvedJarMessageParameters(), this.getUnresolvedJarMessageParameters(), jarWithEagerSink);
        try {
            handler.handleRequest(request, (DispatcherGateway)restfulGateway).get();
        }
        catch (ExecutionException e) {
            Throwable throwable = ExceptionUtils.stripCompletionException((Throwable)e.getCause());
            Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(RestHandlerException.class));
            RestHandlerException restHandlerException = (RestHandlerException)throwable;
            Assert.assertThat((Object)restHandlerException.getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.BAD_REQUEST));
            Optional invocationException = ExceptionUtils.findThrowable((Throwable)restHandlerException, ProgramInvocationException.class);
            if (!invocationException.isPresent()) {
                Assert.fail();
            }
            String exceptionMsg = ((ProgramInvocationException)invocationException.get()).getMessage();
            Assert.assertThat((Object)exceptionMsg, (Matcher)Matchers.containsString((String)"Job was submitted in detached mode."));
            return;
        }
        Assert.fail((String)"The test should have failed.");
    }

    @Override
    void handleRequest(HandlerRequest<JarRunRequestBody, JarRunMessageParameters> request) throws Exception {
        handler.handleRequest(request, (DispatcherGateway)restfulGateway).get();
    }

    @Override
    JobGraph validateDefaultGraph() {
        JobGraph jobGraph = super.validateDefaultGraph();
        SavepointRestoreSettings savepointRestoreSettings = jobGraph.getSavepointRestoreSettings();
        Assert.assertFalse((boolean)savepointRestoreSettings.allowNonRestoredState());
        Assert.assertNull((Object)savepointRestoreSettings.getRestorePath());
        return jobGraph;
    }

    @Override
    JobGraph validateGraph() {
        JobGraph jobGraph = super.validateGraph();
        SavepointRestoreSettings savepointRestoreSettings = jobGraph.getSavepointRestoreSettings();
        Assert.assertTrue((boolean)savepointRestoreSettings.allowNonRestoredState());
        Assert.assertEquals((Object)RESTORE_PATH, (Object)savepointRestoreSettings.getRestorePath());
        return jobGraph;
    }

    private static class ConfigurationVerifyingDetachedApplicationRunner
    extends DetachedApplicationRunner {
        public ConfigurationVerifyingDetachedApplicationRunner() {
            super(true);
        }

        public List<JobID> run(DispatcherGateway dispatcherGateway, PackagedProgram program, Configuration configuration) {
            Assert.assertFalse((boolean)((Boolean)configuration.get(DeploymentOptions.ATTACHED)));
            Assert.assertEquals((Object)"embedded", (Object)configuration.get(DeploymentOptions.TARGET));
            return super.run(dispatcherGateway, program, configuration);
        }
    }
}

