/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.jsonplan.JsonPlanGenerator;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarHandlerParameterTest;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanGetHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanRequestBody;
import org.apache.flink.runtime.webmonitor.testutils.ParameterProgram;
import org.junit.BeforeClass;

public class JarPlanHandlerParameterTest
extends JarHandlerParameterTest<JarPlanRequestBody, JarPlanMessageParameters> {
    private static JarPlanHandler handler;

    @BeforeClass
    public static void setup() throws Exception {
        JarPlanHandlerParameterTest.init();
        handler = new JarPlanHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarPlanGetHeaders.getInstance(), jarDir, new Configuration(), executor, jobGraph -> {
            LAST_SUBMITTED_JOB_GRAPH_REFERENCE.set(jobGraph);
            return new JobPlanInfo(JsonPlanGenerator.generatePlan((JobGraph)jobGraph));
        });
    }

    @Override
    JarPlanMessageParameters getUnresolvedJarMessageParameters() {
        return (JarPlanMessageParameters)handler.getMessageHeaders().getUnresolvedMessageParameters();
    }

    @Override
    JarPlanMessageParameters getJarMessageParameters(JarHandlerParameterTest.ProgramArgsParType programArgsParType) {
        JarPlanMessageParameters parameters = this.getUnresolvedJarMessageParameters();
        parameters.entryClassQueryParameter.resolve(Collections.singletonList(ParameterProgram.class.getCanonicalName()));
        parameters.parallelismQueryParameter.resolve(Collections.singletonList(4));
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.String || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgsQueryParameter.resolve(Collections.singletonList(String.join((CharSequence)" ", PROG_ARGS)));
        }
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.List || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgQueryParameter.resolve(Arrays.asList(PROG_ARGS));
        }
        return parameters;
    }

    @Override
    JarPlanMessageParameters getWrongJarMessageParameters(JarHandlerParameterTest.ProgramArgsParType programArgsParType) {
        List wrongArgs = Arrays.stream(PROG_ARGS).map(a -> a + "wrong").collect(Collectors.toList());
        String argsWrongStr = String.join((CharSequence)" ", wrongArgs);
        JarPlanMessageParameters parameters = this.getUnresolvedJarMessageParameters();
        parameters.entryClassQueryParameter.resolve(Collections.singletonList("please.dont.run.me"));
        parameters.parallelismQueryParameter.resolve(Collections.singletonList(64));
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.String || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgsQueryParameter.resolve(Collections.singletonList(argsWrongStr));
        }
        if (programArgsParType == JarHandlerParameterTest.ProgramArgsParType.List || programArgsParType == JarHandlerParameterTest.ProgramArgsParType.Both) {
            parameters.programArgQueryParameter.resolve(wrongArgs);
        }
        return parameters;
    }

    @Override
    JarPlanRequestBody getDefaultJarRequestBody() {
        return new JarPlanRequestBody();
    }

    @Override
    JarPlanRequestBody getJarRequestBody(JarHandlerParameterTest.ProgramArgsParType programArgsParType) {
        return new JarPlanRequestBody(ParameterProgram.class.getCanonicalName(), JarPlanHandlerParameterTest.getProgramArgsString(programArgsParType), JarPlanHandlerParameterTest.getProgramArgsList(programArgsParType), Integer.valueOf(4), null);
    }

    @Override
    JarPlanRequestBody getJarRequestBodyWithJobId(JobID jobId) {
        return new JarPlanRequestBody(null, null, null, null, jobId);
    }

    @Override
    void handleRequest(HandlerRequest<JarPlanRequestBody, JarPlanMessageParameters> request) throws Exception {
        handler.handleRequest(request, (RestfulGateway)restfulGateway).get();
    }
}

