/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.deployment.application.DetachedApplicationRunner;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobPlanInfo;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarListHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarListHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarListInfo;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanGetHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarPlanRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarRunHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarRunMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRunRequestBody;
import org.apache.flink.runtime.webmonitor.handlers.JarRunResponseBody;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarUploadResponseBody;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JarHandlers {
    final JarUploadHandler uploadHandler;
    final JarListHandler listHandler;
    final JarPlanHandler planHandler;
    final JarRunHandler runHandler;
    final JarDeleteHandler deleteHandler;

    JarHandlers(Path jarDir, TestingDispatcherGateway restfulGateway) {
        GatewayRetriever gatewayRetriever = () -> CompletableFuture.completedFuture(restfulGateway);
        Time timeout = Time.seconds((long)10L);
        Map responseHeaders = Collections.emptyMap();
        ScheduledExecutorService executor = TestingUtils.defaultExecutor();
        this.uploadHandler = new JarUploadHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarUploadHeaders.getInstance(), jarDir, (Executor)executor);
        this.listHandler = new JarListHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarListHeaders.getInstance(), CompletableFuture.completedFuture("shazam://localhost:12345"), jarDir.toFile(), new Configuration(), (Executor)executor);
        this.planHandler = new JarPlanHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarPlanGetHeaders.getInstance(), jarDir, new Configuration(), (Executor)executor);
        this.runHandler = new JarRunHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarRunHeaders.getInstance(), jarDir, new Configuration(), (Executor)executor, () -> new DetachedApplicationRunner(true));
        this.deleteHandler = new JarDeleteHandler(gatewayRetriever, timeout, responseHeaders, (MessageHeaders)JarDeleteHeaders.getInstance(), jarDir, (Executor)executor);
    }

    public static String uploadJar(JarUploadHandler handler, Path jar, RestfulGateway restfulGateway) throws Exception {
        HandlerRequest uploadRequest = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance(), Collections.emptyMap(), Collections.emptyMap(), Collections.singletonList(jar.toFile()));
        JarUploadResponseBody uploadResponse = (JarUploadResponseBody)handler.handleRequest(uploadRequest, restfulGateway).get();
        return uploadResponse.getFilename();
    }

    public static JarListInfo listJars(JarListHandler handler, RestfulGateway restfulGateway) throws Exception {
        HandlerRequest listRequest = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)EmptyMessageParameters.getInstance());
        return (JarListInfo)handler.handleRequest(listRequest, restfulGateway).get();
    }

    public static JobPlanInfo showPlan(JarPlanHandler handler, String jarName, RestfulGateway restfulGateway) throws Exception {
        JarPlanMessageParameters planParameters = JarPlanGetHeaders.getInstance().getUnresolvedMessageParameters();
        HandlerRequest planRequest = new HandlerRequest((RequestBody)new JarPlanRequestBody(), (MessageParameters)planParameters, Collections.singletonMap(planParameters.jarIdPathParameter.getKey(), jarName), Collections.emptyMap(), Collections.emptyList());
        return (JobPlanInfo)handler.handleRequest(planRequest, restfulGateway).get();
    }

    public static JarRunResponseBody runJar(JarRunHandler handler, String jarName, DispatcherGateway restfulGateway) throws Exception {
        JarRunMessageParameters runParameters = JarRunHeaders.getInstance().getUnresolvedMessageParameters();
        HandlerRequest runRequest = new HandlerRequest((RequestBody)new JarRunRequestBody(), (MessageParameters)runParameters, Collections.singletonMap(runParameters.jarIdPathParameter.getKey(), jarName), Collections.emptyMap(), Collections.emptyList());
        return (JarRunResponseBody)handler.handleRequest(runRequest, restfulGateway).get();
    }

    public static void deleteJar(JarDeleteHandler handler, String jarName, RestfulGateway restfulGateway) throws Exception {
        JarDeleteMessageParameters deleteParameters = JarDeleteHeaders.getInstance().getUnresolvedMessageParameters();
        HandlerRequest deleteRequest = new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)deleteParameters, Collections.singletonMap(deleteParameters.jarIdPathParameter.getKey(), jarName), Collections.emptyMap(), Collections.emptyList());
        handler.handleRequest(deleteRequest, restfulGateway).get();
    }
}

