/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarHandlers;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JarHandlerTest
extends TestLogger {
    private static final String JAR_NAME = "output-test-program.jar";
    @ClassRule
    public static final TemporaryFolder TMP = new TemporaryFolder();

    @Test
    public void testPlanJar() throws Exception {
        JarHandlerTest.runTest("hello out!", "hello err!");
    }

    private static void runTest(String expectedCapturedStdOut, String expectedCapturedStdErr) throws Exception {
        TestingDispatcherGateway restfulGateway = new TestingDispatcherGateway.Builder().build();
        JarHandlers handlers = new JarHandlers(TMP.newFolder().toPath(), restfulGateway);
        Path originalJar = Paths.get(System.getProperty("targetDir"), new String[0]).resolve(JAR_NAME);
        Path jar = Files.copy(originalJar, TMP.newFolder().toPath().resolve(JAR_NAME), new CopyOption[0]);
        String storedJarPath = JarHandlers.uploadJar(handlers.uploadHandler, jar, (RestfulGateway)restfulGateway);
        String storedJarName = Paths.get(storedJarPath, new String[0]).getFileName().toString();
        try {
            JarHandlers.showPlan(handlers.planHandler, storedJarName, (RestfulGateway)restfulGateway);
            Assert.fail((String)"Should have failed with an exception.");
        }
        catch (Exception e) {
            Optional expected = ExceptionUtils.findThrowable((Throwable)e, ProgramInvocationException.class);
            if (expected.isPresent()) {
                String message = ((ProgramInvocationException)expected.get()).getMessage();
                MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"The program plan could not be fetched - the program aborted pre-maturely"));
                MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)JAR_NAME));
                MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)("System.out: " + expectedCapturedStdOut)));
                MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)("System.err: " + expectedCapturedStdErr)));
            }
            throw e;
        }
    }
}

