/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.MessageParameter;
import org.apache.flink.runtime.rest.messages.MessageQueryParameter;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.apache.flink.runtime.util.BlobServerResource;
import org.apache.flink.runtime.webmonitor.TestingDispatcherGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarMessageParameters;
import org.apache.flink.runtime.webmonitor.handlers.JarRequestBody;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.testutils.ParameterProgram;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public abstract class JarHandlerParameterTest<REQB extends JarRequestBody, M extends JarMessageParameters>
extends TestLogger {
    static final String[] PROG_ARGS = new String[]{"--host", "localhost", "--port", "1234"};
    static final int PARALLELISM = 4;
    @ClassRule
    public static final TemporaryFolder TMP = new TemporaryFolder();
    @ClassRule
    public static final BlobServerResource BLOB_SERVER_RESOURCE = new BlobServerResource();
    static final AtomicReference<JobGraph> LAST_SUBMITTED_JOB_GRAPH_REFERENCE = new AtomicReference();
    static TestingDispatcherGateway restfulGateway;
    static Path jarDir;
    static GatewayRetriever<TestingDispatcherGateway> gatewayRetriever;
    static CompletableFuture<String> localAddressFuture;
    static Time timeout;
    static Map<String, String> responseHeaders;
    static Executor executor;
    private static Path jarWithManifest;
    private static Path jarWithoutManifest;

    static void init() throws Exception {
        jarDir = TMP.newFolder().toPath();
        String parameterProgramJarName = System.getProperty("parameterJarName") + ".jar";
        String parameterProgramWithoutManifestJarName = System.getProperty("parameterJarWithoutManifestName") + ".jar";
        Path jarLocation = Paths.get(System.getProperty("targetDir"), new String[0]);
        jarWithManifest = Files.copy(jarLocation.resolve(parameterProgramJarName), jarDir.resolve("program-with-manifest.jar"), new CopyOption[0]);
        jarWithoutManifest = Files.copy(jarLocation.resolve(parameterProgramWithoutManifestJarName), jarDir.resolve("program-without-manifest.jar"), new CopyOption[0]);
        restfulGateway = new TestingDispatcherGateway.Builder().setBlobServerPort(BLOB_SERVER_RESOURCE.getBlobServerPort()).setSubmitFunction(jobGraph -> {
            LAST_SUBMITTED_JOB_GRAPH_REFERENCE.set((JobGraph)jobGraph);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).build();
        gatewayRetriever = () -> CompletableFuture.completedFuture(restfulGateway);
        localAddressFuture = CompletableFuture.completedFuture("shazam://localhost:12345");
        timeout = Time.seconds((long)10L);
        responseHeaders = Collections.emptyMap();
        executor = TestingUtils.defaultExecutor();
    }

    @Before
    public void reset() {
        ParameterProgram.actualArguments = null;
    }

    @Test
    public void testDefaultParameters() throws Exception {
        this.handleRequest(JarHandlerParameterTest.createRequest(this.getDefaultJarRequestBody(), this.getUnresolvedJarMessageParameters(), this.getUnresolvedJarMessageParameters(), jarWithManifest));
        this.validateDefaultGraph();
    }

    @Test
    public void testConfigurationViaQueryParametersWithProgArgsAsString() throws Exception {
        this.testConfigurationViaQueryParameters(ProgramArgsParType.String);
    }

    @Test
    public void testConfigurationViaQueryParametersWithProgArgsAsList() throws Exception {
        this.testConfigurationViaQueryParameters(ProgramArgsParType.List);
    }

    @Test
    public void testConfigurationViaQueryParametersFailWithProgArgsAsStringAndList() throws Exception {
        try {
            this.testConfigurationViaQueryParameters(ProgramArgsParType.Both);
            TestCase.fail((String)"RestHandlerException is excepted");
        }
        catch (RestHandlerException e) {
            TestCase.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)e.getHttpResponseStatus());
        }
    }

    private void testConfigurationViaQueryParameters(ProgramArgsParType programArgsParType) throws Exception {
        this.handleRequest(JarHandlerParameterTest.createRequest(this.getDefaultJarRequestBody(), this.getJarMessageParameters(programArgsParType), this.getUnresolvedJarMessageParameters(), jarWithoutManifest));
        this.validateGraph();
    }

    @Test
    public void testConfigurationViaJsonRequestWithProgArgsAsString() throws Exception {
        this.testConfigurationViaJsonRequest(ProgramArgsParType.String);
    }

    @Test
    public void testConfigurationViaJsonRequestWithProgArgsAsList() throws Exception {
        this.testConfigurationViaJsonRequest(ProgramArgsParType.List);
    }

    @Test
    public void testConfigurationViaJsonRequestFailWithProgArgsAsStringAndList() throws Exception {
        try {
            this.testConfigurationViaJsonRequest(ProgramArgsParType.Both);
            TestCase.fail((String)"RestHandlerException is excepted");
        }
        catch (RestHandlerException e) {
            TestCase.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)e.getHttpResponseStatus());
        }
    }

    @Test
    public void testProvideJobId() throws Exception {
        JobID jobId = new JobID();
        HandlerRequest<REQB, M> request = JarHandlerParameterTest.createRequest(this.getJarRequestBodyWithJobId(jobId), this.getUnresolvedJarMessageParameters(), this.getUnresolvedJarMessageParameters(), jarWithManifest);
        this.handleRequest(request);
        Optional<JobGraph> jobGraph = JarHandlerParameterTest.getLastSubmittedJobGraphAndReset();
        MatcherAssert.assertThat((Object)jobGraph.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)jobGraph.get().getJobID(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)jobId)));
    }

    private void testConfigurationViaJsonRequest(ProgramArgsParType programArgsParType) throws Exception {
        this.handleRequest(JarHandlerParameterTest.createRequest(this.getJarRequestBody(programArgsParType), this.getUnresolvedJarMessageParameters(), this.getUnresolvedJarMessageParameters(), jarWithoutManifest));
        this.validateGraph();
    }

    @Test
    public void testParameterPrioritizationWithProgArgsAsString() throws Exception {
        this.testParameterPrioritization(ProgramArgsParType.String);
    }

    @Test
    public void testParameterPrioritizationWithProgArgsAsList() throws Exception {
        this.testParameterPrioritization(ProgramArgsParType.List);
    }

    @Test
    public void testFailIfProgArgsAreAsStringAndAsList() throws Exception {
        try {
            this.testParameterPrioritization(ProgramArgsParType.Both);
            TestCase.fail((String)"RestHandlerException is excepted");
        }
        catch (RestHandlerException e) {
            TestCase.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)e.getHttpResponseStatus());
        }
    }

    private void testParameterPrioritization(ProgramArgsParType programArgsParType) throws Exception {
        this.handleRequest(JarHandlerParameterTest.createRequest(this.getJarRequestBody(programArgsParType), this.getWrongJarMessageParameters(programArgsParType), this.getUnresolvedJarMessageParameters(), jarWithoutManifest));
        this.validateGraph();
    }

    static String getProgramArgsString(ProgramArgsParType programArgsParType) {
        return programArgsParType == ProgramArgsParType.String || programArgsParType == ProgramArgsParType.Both ? String.join((CharSequence)" ", PROG_ARGS) : null;
    }

    static List<String> getProgramArgsList(ProgramArgsParType programArgsParType) {
        return programArgsParType == ProgramArgsParType.List || programArgsParType == ProgramArgsParType.Both ? Arrays.asList(PROG_ARGS) : null;
    }

    protected static <REQB extends JarRequestBody, M extends JarMessageParameters> HandlerRequest<REQB, M> createRequest(REQB requestBody, M parameters, M unresolvedMessageParameters, Path jar) throws HandlerRequestException {
        Map<String, List> queryParameterAsMap = parameters.getQueryParameters().stream().filter(MessageParameter::isResolved).collect(Collectors.toMap(MessageParameter::getKey, JarHandlerParameterTest::getValuesAsString));
        return new HandlerRequest(requestBody, unresolvedMessageParameters, Collections.singletonMap("jarid", jar.getFileName().toString()), queryParameterAsMap, Collections.emptyList());
    }

    private static <X> List<String> getValuesAsString(MessageQueryParameter<X> parameter) {
        List values = (List)parameter.getValue();
        return values.stream().map(arg_0 -> parameter.convertValueToString(arg_0)).collect(Collectors.toList());
    }

    abstract M getUnresolvedJarMessageParameters();

    abstract M getJarMessageParameters(ProgramArgsParType var1);

    abstract M getWrongJarMessageParameters(ProgramArgsParType var1);

    abstract REQB getDefaultJarRequestBody();

    abstract REQB getJarRequestBody(ProgramArgsParType var1);

    abstract REQB getJarRequestBodyWithJobId(JobID var1);

    abstract void handleRequest(HandlerRequest<REQB, M> var1) throws Exception;

    JobGraph validateDefaultGraph() {
        JobGraph jobGraph = LAST_SUBMITTED_JOB_GRAPH_REFERENCE.getAndSet(null);
        Assert.assertEquals((long)0L, (long)ParameterProgram.actualArguments.length);
        Assert.assertEquals((long)((Integer)CoreOptions.DEFAULT_PARALLELISM.defaultValue()).intValue(), (long)JarHandlerParameterTest.getExecutionConfig(jobGraph).getParallelism());
        return jobGraph;
    }

    JobGraph validateGraph() {
        JobGraph jobGraph = LAST_SUBMITTED_JOB_GRAPH_REFERENCE.getAndSet(null);
        Assert.assertArrayEquals((Object[])PROG_ARGS, (Object[])ParameterProgram.actualArguments);
        Assert.assertEquals((long)4L, (long)JarHandlerParameterTest.getExecutionConfig(jobGraph).getParallelism());
        return jobGraph;
    }

    private static Optional<JobGraph> getLastSubmittedJobGraphAndReset() {
        return Optional.ofNullable(LAST_SUBMITTED_JOB_GRAPH_REFERENCE.getAndSet(null));
    }

    private static ExecutionConfig getExecutionConfig(JobGraph jobGraph) {
        ExecutionConfig executionConfig;
        try {
            executionConfig = (ExecutionConfig)jobGraph.getSerializedExecutionConfig().deserializeValue(ParameterProgram.class.getClassLoader());
        }
        catch (Exception e) {
            throw new AssertionError("Exception while deserializing ExecutionConfig.", e);
        }
        return executionConfig;
    }

    static {
        gatewayRetriever = () -> CompletableFuture.completedFuture(restfulGateway);
        localAddressFuture = CompletableFuture.completedFuture("shazam://localhost:12345");
        timeout = Time.seconds((long)10L);
        responseHeaders = Collections.emptyMap();
        executor = TestingUtils.defaultExecutor();
    }

    static enum ProgramArgsParType {
        String,
        List,
        Both;

    }
}

