/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.HandlerRequestException;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHandler;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteHeaders;
import org.apache.flink.runtime.webmonitor.handlers.JarDeleteMessageParameters;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JarDeleteHandlerTest
extends TestLogger {
    private static final String TEST_JAR_NAME = "test.jar";
    private JarDeleteHandler jarDeleteHandler;
    private RestfulGateway restfulGateway;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path jarDir;

    @Before
    public void setUp() throws Exception {
        this.jarDir = this.temporaryFolder.newFolder().toPath();
        this.restfulGateway = new TestingRestfulGateway.Builder().build();
        this.jarDeleteHandler = new JarDeleteHandler(() -> CompletableFuture.completedFuture(this.restfulGateway), Time.seconds((long)10L), Collections.emptyMap(), (MessageHeaders)new JarDeleteHeaders(), this.jarDir, Executors.directExecutor());
        Files.createFile(this.jarDir.resolve(TEST_JAR_NAME), new FileAttribute[0]);
    }

    @Test
    public void testDeleteJarById() throws Exception {
        Assert.assertThat((Object)Files.exists(this.jarDir.resolve(TEST_JAR_NAME), new LinkOption[0]), (Matcher)Matchers.equalTo((Object)true));
        HandlerRequest<EmptyRequestBody, JarDeleteMessageParameters> request = JarDeleteHandlerTest.createRequest(TEST_JAR_NAME);
        this.jarDeleteHandler.handleRequest(request, this.restfulGateway).get();
        Assert.assertThat((Object)Files.exists(this.jarDir.resolve(TEST_JAR_NAME), new LinkOption[0]), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void testDeleteUnknownJar() throws Exception {
        HandlerRequest<EmptyRequestBody, JarDeleteMessageParameters> request = JarDeleteHandlerTest.createRequest("doesnotexist.jar");
        try {
            this.jarDeleteHandler.handleRequest(request, this.restfulGateway).get();
        }
        catch (ExecutionException e) {
            Throwable throwable = ExceptionUtils.stripCompletionException((Throwable)e.getCause());
            Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(RestHandlerException.class));
            RestHandlerException restHandlerException = (RestHandlerException)throwable;
            Assert.assertThat((Object)restHandlerException.getMessage(), (Matcher)Matchers.containsString((String)"File doesnotexist.jar does not exist in"));
            Assert.assertThat((Object)restHandlerException.getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.BAD_REQUEST));
            return;
        }
        Assert.fail((String)"The test should have failed by now.");
    }

    @Test
    public void testFailedDelete() throws Exception {
        this.makeJarDirReadOnly();
        HandlerRequest<EmptyRequestBody, JarDeleteMessageParameters> request = JarDeleteHandlerTest.createRequest(TEST_JAR_NAME);
        try {
            this.jarDeleteHandler.handleRequest(request, this.restfulGateway).get();
        }
        catch (ExecutionException e) {
            Throwable throwable = ExceptionUtils.stripCompletionException((Throwable)e.getCause());
            Assert.assertThat((Object)throwable, (Matcher)Matchers.instanceOf(RestHandlerException.class));
            RestHandlerException restHandlerException = (RestHandlerException)throwable;
            Assert.assertThat((Object)restHandlerException.getMessage(), (Matcher)Matchers.containsString((String)"Failed to delete jar"));
            Assert.assertThat((Object)restHandlerException.getHttpResponseStatus(), (Matcher)Matchers.equalTo((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR));
        }
    }

    private static HandlerRequest<EmptyRequestBody, JarDeleteMessageParameters> createRequest(String jarFileName) throws HandlerRequestException {
        return new HandlerRequest((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JarDeleteMessageParameters(), Collections.singletonMap("jarid", jarFileName), Collections.emptyMap());
    }

    private void makeJarDirReadOnly() {
        try {
            Files.setPosixFilePermissions(this.jarDir, new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OTHERS_READ, PosixFilePermission.GROUP_READ, PosixFilePermission.OWNER_READ, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OWNER_EXECUTE)));
        }
        catch (Exception e) {
            Assume.assumeNoException((Throwable)e);
        }
    }
}

