/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.handler.LeaderRetrievalHandler;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.router.Router;
import org.apache.flink.runtime.rest.handler.util.HandlerRedirectUtils;
import org.apache.flink.runtime.rest.handler.util.KeepAliveWrite;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.runtime.webmonitor.testutils.HttpTestClient;
import org.apache.flink.runtime.webmonitor.utils.WebFrontendBootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpRequest;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.junit.Assert;
import org.junit.Test;

public class LeaderRetrievalHandlerTest
extends TestLogger {
    private static final String RESPONSE_MESSAGE = "foobar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLeaderRetrievalGateway() throws Exception {
        String restPath = "/testing";
        Configuration configuration = new Configuration();
        Router router = new Router();
        Time timeout = Time.seconds((long)10L);
        CompletableFuture<TestingRestfulGateway> gatewayFuture = new CompletableFuture<TestingRestfulGateway>();
        GatewayRetriever gatewayRetriever = () -> gatewayFuture;
        TestingRestfulGateway gateway = new TestingRestfulGateway.Builder().build();
        TestingHandler testingHandler = new TestingHandler((GatewayRetriever<RestfulGateway>)gatewayRetriever, timeout);
        router.addGet("/testing", (Object)testingHandler);
        WebFrontendBootstrap bootstrap = new WebFrontendBootstrap(router, this.log, null, null, "localhost", 0, configuration);
        try (HttpTestClient httpClient = new HttpTestClient("localhost", bootstrap.getServerPort());){
            httpClient.sendGetRequest("/testing", FutureUtils.toDuration((Time)timeout));
            HttpTestClient.SimpleHttpResponse response = httpClient.getNextResponse(FutureUtils.toDuration((Time)timeout));
            Assert.assertEquals((Object)HttpResponseStatus.SERVICE_UNAVAILABLE, (Object)response.getStatus());
            gatewayFuture.complete(gateway);
            httpClient.sendGetRequest("/testing", FutureUtils.toDuration((Time)timeout));
            response = httpClient.getNextResponse(FutureUtils.toDuration((Time)timeout));
            Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.getStatus());
            Assert.assertEquals((Object)RESPONSE_MESSAGE, (Object)response.getContent());
        }
        finally {
            bootstrap.shutdown();
        }
    }

    private static class TestingHandler
    extends LeaderRetrievalHandler<RestfulGateway> {
        protected TestingHandler(@Nonnull GatewayRetriever<RestfulGateway> leaderRetriever, @Nonnull Time timeout) {
            super(leaderRetriever, timeout, Collections.emptyMap());
        }

        protected void respondAsLeader(ChannelHandlerContext channelHandlerContext, RoutedRequest routedRequest, RestfulGateway gateway) throws Exception {
            Assert.assertTrue((boolean)channelHandlerContext.channel().eventLoop().inEventLoop());
            HttpResponse response = HandlerRedirectUtils.getResponse((HttpResponseStatus)HttpResponseStatus.OK, (String)LeaderRetrievalHandlerTest.RESPONSE_MESSAGE);
            KeepAliveWrite.flush((Channel)channelHandlerContext.channel(), (HttpRequest)routedRequest.getRequest(), (HttpResponse)response);
        }
    }
}

