/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.compatibility;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.compatibility.Compatibility;
import org.apache.flink.runtime.rest.compatibility.CompatibilityCheckResult;
import org.apache.flink.runtime.rest.compatibility.CompatibilityRoutine;
import org.apache.flink.runtime.rest.compatibility.CompatibilityRoutines;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.util.DocumentingDispatcherRestEndpoint;
import org.apache.flink.runtime.rest.util.DocumentingRestEndpoint;
import org.apache.flink.runtime.rest.versioning.RestAPIVersion;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.PrettyPrinter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.util.DefaultIndenter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public final class RestAPIStabilityTest
extends TestLogger {
    private static final String REGENERATE_SNAPSHOT_PROPERTY = "generate-rest-snapshot";
    private static final String SNAPSHOT_RESOURCE_PATTERN = "rest_api_%s.snapshot";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final RestAPIVersion apiVersion;

    @Parameterized.Parameters(name="version = {0}")
    public static Iterable<RestAPIVersion> getStableVersions() {
        return Arrays.stream(RestAPIVersion.values()).filter(RestAPIVersion::isStableVersion).collect(Collectors.toList());
    }

    public RestAPIStabilityTest(RestAPIVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Test
    public void testDispatcherRestAPIStability() throws IOException, ConfigurationException {
        URL resource;
        String versionedSnapshotFileName = String.format(SNAPSHOT_RESOURCE_PATTERN, this.apiVersion.getURLVersionPrefix());
        RestAPISnapshot currentSnapshot = this.createSnapshot((DocumentingRestEndpoint)new DocumentingDispatcherRestEndpoint());
        if (System.getProperty(REGENERATE_SNAPSHOT_PROPERTY) != null) {
            RestAPIStabilityTest.writeSnapshot(versionedSnapshotFileName, currentSnapshot);
        }
        if ((resource = RestAPIStabilityTest.class.getClassLoader().getResource(versionedSnapshotFileName)) == null) {
            Assert.fail((String)"Snapshot file does not exist. If you added a new version, re-run this test with -Dgenerate-rest-snapshot being set.");
        }
        RestAPISnapshot previousSnapshot = (RestAPISnapshot)OBJECT_MAPPER.readValue(resource, RestAPISnapshot.class);
        RestAPIStabilityTest.assertCompatible(previousSnapshot, currentSnapshot);
    }

    private static void writeSnapshot(String versionedSnapshotFileName, RestAPISnapshot snapshot) throws IOException {
        OBJECT_MAPPER.writer((PrettyPrinter)new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter().withLinefeed("\n"))).writeValue(new File("src/test/resources/" + versionedSnapshotFileName), (Object)snapshot);
        System.out.println("REST API snapshot " + versionedSnapshotFileName + " was updated, please remember to commit the snapshot.");
    }

    private RestAPISnapshot createSnapshot(DocumentingRestEndpoint restEndpoint) {
        List<JsonNode> calls = restEndpoint.getSpecs().stream().filter(spec -> spec.getSupportedAPIVersions().contains(this.apiVersion)).map(spec -> {
            ObjectNode json = OBJECT_MAPPER.createObjectNode();
            for (CompatibilityRoutine<?> routine : CompatibilityRoutines.ROUTINES) {
                Object extract = routine.getContainer((MessageHeaders<?, ?, ?>)spec);
                json.set(routine.getKey(), OBJECT_MAPPER.valueToTree(extract));
            }
            return json;
        }).collect(Collectors.toList());
        return new RestAPISnapshot(calls);
    }

    private static void assertCompatible(RestAPISnapshot old, RestAPISnapshot cur) {
        List<Object> compatibilityCheckResults;
        for (JsonNode oldCall2 : old.calls) {
            compatibilityCheckResults = cur.calls.stream().map(curCall -> Tuple2.of((Object)curCall, (Object)RestAPIStabilityTest.checkCompatibility(oldCall2, curCall))).collect(Collectors.toList());
            if (compatibilityCheckResults.stream().allMatch(result -> ((CompatibilityCheckResult)result.f1).getBackwardCompatibility() == Compatibility.INCOMPATIBLE)) {
                RestAPIStabilityTest.fail(oldCall2, compatibilityCheckResults);
            }
            if (!compatibilityCheckResults.stream().noneMatch(result -> ((CompatibilityCheckResult)result.f1).getBackwardCompatibility() == Compatibility.IDENTICAL)) continue;
            Assert.fail((String)"The API was modified in a compatible way, but the snapshot was not updated. To update the snapshot, re-run this test with -Dgenerate-rest-snapshot being set. If you see this message in a CI pipeline, rerun the test locally and commit the generated changes.");
        }
        for (JsonNode curCall2 : cur.calls) {
            compatibilityCheckResults = old.calls.stream().map(oldCall -> Tuple2.of((Object)curCall2, (Object)RestAPIStabilityTest.checkCompatibility(oldCall, curCall2))).collect(Collectors.toList());
            if (!compatibilityCheckResults.stream().noneMatch(result -> ((CompatibilityCheckResult)result.f1).getBackwardCompatibility() == Compatibility.IDENTICAL)) continue;
            Assert.fail((String)"The API was modified in a compatible way, but the snapshot was not updated. To update the snapshot, re-run this test with -Dgenerate-rest-snapshot being set.");
        }
    }

    private static void fail(JsonNode oldCall, List<Tuple2<JsonNode, CompatibilityCheckResult>> compatibilityCheckResults) {
        StringBuilder sb = new StringBuilder();
        sb.append("No compatible call could be found for " + oldCall + '.');
        compatibilityCheckResults.stream().sorted(Collections.reverseOrder(Comparator.comparingInt(tuple -> ((CompatibilityCheckResult)tuple.f1).getBackwardCompatibilityGrade()))).forEachOrdered(result -> {
            sb.append(System.lineSeparator());
            sb.append("\tRejected by candidate: " + result.f0 + '.');
            sb.append(System.lineSeparator());
            sb.append("\tCompatibility grade: " + ((CompatibilityCheckResult)result.f1).getBackwardCompatibilityGrade() + '/' + CompatibilityRoutines.ROUTINES.size());
            sb.append(System.lineSeparator());
            sb.append("\tIncompatibilities: ");
            for (AssertionError error : ((CompatibilityCheckResult)result.f1).getBackwardCompatibilityErrors()) {
                sb.append(System.lineSeparator());
                sb.append("\t\t" + ((Throwable)((Object)error)).getMessage());
            }
        });
        Assert.fail((String)sb.toString());
    }

    private static CompatibilityCheckResult checkCompatibility(JsonNode oldCall, JsonNode newCall) {
        return CompatibilityRoutines.ROUTINES.stream().map(routine -> RestAPIStabilityTest.checkCompatibility(routine, oldCall, newCall)).reduce(CompatibilityCheckResult::merge).get();
    }

    private static <X> CompatibilityCheckResult checkCompatibility(CompatibilityRoutine<X> routine, JsonNode oldCall, JsonNode curCall) {
        Optional<X> old = RestAPIStabilityTest.readJson(routine, oldCall);
        Optional<X> cur = RestAPIStabilityTest.readJson(routine, curCall);
        return routine.checkCompatibility(old, cur);
    }

    private static <X> Optional<X> readJson(CompatibilityRoutine<X> routine, JsonNode call) {
        Optional<JsonNode> jsonContainer = Optional.ofNullable(call.get(routine.getKey()));
        return jsonContainer.map(container -> RestAPIStabilityTest.jsonToObject(container, routine.getContainerClass()));
    }

    private static <X> X jsonToObject(JsonNode jsonContainer, Class<X> containerClass) {
        try {
            return (X)OBJECT_MAPPER.treeToValue((TreeNode)jsonContainer, containerClass);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static final class RestAPISnapshot {
        public List<JsonNode> calls;

        private RestAPISnapshot() {
        }

        RestAPISnapshot(List<JsonNode> calls) {
            this.calls = calls;
        }
    }
}

