/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.stats.OperatorCheckpointStats;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.JobVertexCheckpointsHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import scala.Option;

public class JobVertexCheckpointsHandlerTest {
    @Test
    public void testNoCoordinator() throws Exception {
        JobVertexCheckpointsHandler handler = new JobVertexCheckpointsHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class));
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        ExecutionJobVertex vertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        Mockito.when((Object)vertex.getGraph()).thenReturn((Object)graph);
        String response = handler.handleRequest(vertex, Collections.emptyMap());
        Assert.assertEquals((Object)"{}", (Object)response);
    }

    @Test
    public void testNoStats() throws Exception {
        JobVertexCheckpointsHandler handler = new JobVertexCheckpointsHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class));
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        ExecutionJobVertex vertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        CheckpointStatsTracker tracker = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        Mockito.when((Object)vertex.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)graph.getCheckpointStatsTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)tracker.getOperatorStats((JobVertexID)Matchers.any(JobVertexID.class))).thenReturn((Object)Option.empty());
        String response = handler.handleRequest(vertex, Collections.emptyMap());
        Assert.assertEquals((Object)"{}", (Object)response);
    }

    @Test
    public void testStats() throws Exception {
        JobVertexCheckpointsHandler handler = new JobVertexCheckpointsHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class));
        JobVertexID vertexId = new JobVertexID();
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        ExecutionJobVertex vertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        CheckpointStatsTracker tracker = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        Mockito.when((Object)vertex.getJobVertexId()).thenReturn((Object)vertexId);
        Mockito.when((Object)vertex.getGraph()).thenReturn((Object)graph);
        Mockito.when((Object)graph.getCheckpointStatsTracker()).thenReturn((Object)tracker);
        long[][] subTaskStats = new long[][]{{1L, 10L}, {2L, 9L}, {3L, 8L}, {4L, 7L}, {5L, 6L}, {6L, 5L}, {7L, 4L}, {8L, 3L}, {9L, 2L}, {10L, 1L}};
        OperatorCheckpointStats stats = new OperatorCheckpointStats(3L, 6812L, 2800L, 1024L, (long[][])subTaskStats);
        Mockito.when((Object)tracker.getOperatorStats((JobVertexID)Matchers.eq((Object)vertexId))).thenReturn((Object)Option.apply((Object)stats));
        String response = handler.handleRequest(vertex, Collections.emptyMap());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        long checkpointId = rootNode.get("id").asLong();
        long timestamp = rootNode.get("timestamp").asLong();
        long duration = rootNode.get("duration").asLong();
        long size = rootNode.get("size").asLong();
        long parallelism = rootNode.get("parallelism").asLong();
        Assert.assertEquals((long)stats.getCheckpointId(), (long)checkpointId);
        Assert.assertEquals((long)stats.getTriggerTimestamp(), (long)timestamp);
        Assert.assertEquals((long)stats.getDuration(), (long)duration);
        Assert.assertEquals((long)stats.getStateSize(), (long)size);
        Assert.assertEquals((long)subTaskStats.length, (long)parallelism);
        JsonNode subTasksNode = rootNode.get("subtasks");
        Assert.assertNotNull((Object)subTasksNode);
        Assert.assertTrue((boolean)subTasksNode.isArray());
        Iterator it = subTasksNode.elements();
        for (int i = 0; i < subTaskStats.length; ++i) {
            JsonNode node = (JsonNode)it.next();
            Assert.assertEquals((long)i, (long)node.get("subtask").asInt());
            Assert.assertEquals((long)subTaskStats[i][0], (long)node.get("duration").asLong());
            Assert.assertEquals((long)subTaskStats[i][1], (long)node.get("size").asLong());
        }
        Assert.assertFalse((boolean)it.hasNext());
    }
}

