/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.webmonitor.BackPressureStatsTracker;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.OperatorBackPressureStats;
import org.apache.flink.runtime.webmonitor.handlers.JobVertexBackPressureHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Option;

public class JobVertexBackPressureHandlerTest {
    @Test
    public void testResponseNoStatsAvailable() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        BackPressureStatsTracker statsTracker = (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class);
        Mockito.when((Object)statsTracker.getOperatorBackPressureStats((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class))).thenReturn((Object)Option.empty());
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class), statsTracker, 9999);
        String response = handler.handleRequest(jobVertex, Collections.emptyMap());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        Assert.assertEquals((long)1L, (long)rootNode.size());
        JsonNode status = rootNode.get("status");
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"deprecated", (Object)status.textValue());
        ((BackPressureStatsTracker)Mockito.verify((Object)statsTracker)).triggerStackTraceSample((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class));
    }

    @Test
    public void testResponseStatsAvailable() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        BackPressureStatsTracker statsTracker = (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class);
        OperatorBackPressureStats stats = new OperatorBackPressureStats(0, System.currentTimeMillis(), new double[]{0.31, 0.48, 1.0, 0.0});
        Mockito.when((Object)statsTracker.getOperatorBackPressureStats((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class))).thenReturn((Object)Option.apply((Object)stats));
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class), statsTracker, 9999);
        String response = handler.handleRequest(jobVertex, Collections.emptyMap());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        Assert.assertEquals((long)4L, (long)rootNode.size());
        JsonNode status = rootNode.get("status");
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"ok", (Object)status.textValue());
        JsonNode backPressureLevel = rootNode.get("backpressure-level");
        Assert.assertNotNull((Object)backPressureLevel);
        Assert.assertEquals((Object)"high", (Object)backPressureLevel.textValue());
        JsonNode endTimeStamp = rootNode.get("end-timestamp");
        Assert.assertNotNull((Object)endTimeStamp);
        Assert.assertEquals((long)stats.getEndTimestamp(), (long)endTimeStamp.longValue());
        JsonNode subTasks = rootNode.get("subtasks");
        Assert.assertEquals((long)stats.getNumberOfSubTasks(), (long)subTasks.size());
        for (int i = 0; i < subTasks.size(); ++i) {
            JsonNode subTask = subTasks.get(i);
            JsonNode index = subTask.get("subtask");
            Assert.assertEquals((long)i, (long)index.intValue());
            JsonNode level = subTask.get("backpressure-level");
            Assert.assertEquals((Object)JobVertexBackPressureHandler.getBackPressureLevel((double)stats.getBackPressureRatio(i)), (Object)level.textValue());
            JsonNode ratio = subTask.get("ratio");
            Assert.assertEquals((double)stats.getBackPressureRatio(i), (double)ratio.doubleValue(), (double)0.0);
        }
        ((BackPressureStatsTracker)Mockito.verify((Object)statsTracker, (VerificationMode)Mockito.never())).triggerStackTraceSample((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class));
    }

    @Test
    public void testResponsePassedRefreshInterval() throws Exception {
        ExecutionJobVertex jobVertex = (ExecutionJobVertex)Mockito.mock(ExecutionJobVertex.class);
        BackPressureStatsTracker statsTracker = (BackPressureStatsTracker)Mockito.mock(BackPressureStatsTracker.class);
        OperatorBackPressureStats stats = new OperatorBackPressureStats(0, System.currentTimeMillis(), new double[]{0.31, 0.48, 1.0, 0.0});
        Mockito.when((Object)statsTracker.getOperatorBackPressureStats((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class))).thenReturn((Object)Option.apply((Object)stats));
        JobVertexBackPressureHandler handler = new JobVertexBackPressureHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class), statsTracker, 0);
        String response = handler.handleRequest(jobVertex, Collections.emptyMap());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        Assert.assertEquals((long)4L, (long)rootNode.size());
        JsonNode status = rootNode.get("status");
        Assert.assertNotNull((Object)status);
        Assert.assertEquals((Object)"deprecated", (Object)status.textValue());
        JsonNode backPressureLevel = rootNode.get("backpressure-level");
        Assert.assertNotNull((Object)backPressureLevel);
        Assert.assertEquals((Object)"high", (Object)backPressureLevel.textValue());
        JsonNode endTimeStamp = rootNode.get("end-timestamp");
        Assert.assertNotNull((Object)endTimeStamp);
        Assert.assertEquals((long)stats.getEndTimestamp(), (long)endTimeStamp.longValue());
        JsonNode subTasks = rootNode.get("subtasks");
        Assert.assertEquals((long)stats.getNumberOfSubTasks(), (long)subTasks.size());
        for (int i = 0; i < subTasks.size(); ++i) {
            JsonNode subTask = subTasks.get(i);
            JsonNode index = subTask.get("subtask");
            Assert.assertEquals((long)i, (long)index.intValue());
            JsonNode level = subTask.get("backpressure-level");
            Assert.assertEquals((Object)JobVertexBackPressureHandler.getBackPressureLevel((double)stats.getBackPressureRatio(i)), (Object)level.textValue());
            JsonNode ratio = subTask.get("ratio");
            Assert.assertEquals((double)stats.getBackPressureRatio(i), (double)ratio.doubleValue(), (double)0.0);
        }
        ((BackPressureStatsTracker)Mockito.verify((Object)statsTracker)).triggerStackTraceSample((ExecutionJobVertex)Matchers.any(ExecutionJobVertex.class));
    }
}

