/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import org.apache.flink.runtime.instance.DummyActorGateway;
import org.apache.flink.runtime.webmonitor.handlers.HandlerRedirectUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Tuple2;

public class HandlerRedirectUtilsTest {
    static final String localJobManagerAddress = "akka.tcp://flink@127.0.0.1:1234/user/foobar";
    static final String remoteURL = "127.0.0.2:1235";
    static final String remotePath = "akka.tcp://flink@127.0.0.2:1235/user/jobmanager";

    @Test
    public void testGetRedirectAddressWithLocalAkkaPath() throws Exception {
        DummyActorGateway leaderGateway = new DummyActorGateway("akka://flink/user/foobar");
        Tuple2 leader = new Tuple2((Object)leaderGateway, (Object)1235);
        String redirectingAddress = HandlerRedirectUtils.getRedirectAddress((String)localJobManagerAddress, (Tuple2)leader);
        Assert.assertNull((Object)redirectingAddress);
    }

    @Test
    public void testGetRedirectAddressWithRemoteAkkaPath() throws Exception {
        DummyActorGateway leaderGateway = new DummyActorGateway(remotePath);
        Tuple2 leader = new Tuple2((Object)leaderGateway, (Object)1235);
        String redirectingAddress = HandlerRedirectUtils.getRedirectAddress((String)localJobManagerAddress, (Tuple2)leader);
        Assert.assertEquals((Object)remoteURL, (Object)redirectingAddress);
    }
}

