/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.testutils;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public class HttpTestClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTestClient.class);
    private final String host;
    private final int port;
    private final EventLoopGroup group;
    private final Bootstrap bootstrap;
    private final BlockingQueue<SimpleHttpResponse> responses = new LinkedBlockingQueue<SimpleHttpResponse>();

    public HttpTestClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.group = new NioEventLoopGroup();
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                p.addLast(new ChannelHandler[]{new ClientHandler(HttpTestClient.this.responses)});
            }
        });
    }

    public void sendRequest(HttpRequest request, FiniteDuration timeout) throws InterruptedException, TimeoutException {
        LOG.debug("Writing {}.", (Object)request);
        ChannelFuture connect = this.bootstrap.connect(this.host, this.port);
        if (!connect.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Connection failed");
        }
        Channel channel = connect.channel();
        channel.writeAndFlush((Object)request);
    }

    public void sendGetRequest(String path, FiniteDuration timeout) throws TimeoutException, InterruptedException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        DefaultFullHttpRequest getRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
        getRequest.headers().set("Host", (Object)this.host);
        getRequest.headers().set("Connection", (Object)"close");
        this.sendRequest((HttpRequest)getRequest, timeout);
    }

    public void sendDeleteRequest(String path, FiniteDuration timeout) throws TimeoutException, InterruptedException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        DefaultFullHttpRequest getRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.DELETE, path);
        getRequest.headers().set("Host", (Object)this.host);
        getRequest.headers().set("Connection", (Object)"close");
        this.sendRequest((HttpRequest)getRequest, timeout);
    }

    public SimpleHttpResponse getNextResponse() throws InterruptedException {
        return this.responses.take();
    }

    public SimpleHttpResponse getNextResponse(FiniteDuration timeout) throws InterruptedException, TimeoutException {
        SimpleHttpResponse response = this.responses.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
        if (response == null) {
            throw new TimeoutException("No response within timeout of " + timeout + " ms");
        }
        return response;
    }

    @Override
    public void close() throws InterruptedException {
        if (this.group != null) {
            this.group.shutdownGracefully();
        }
        LOG.debug("Closed");
    }

    @ChannelHandler.Sharable
    private static class ClientHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        private final BlockingQueue<SimpleHttpResponse> responses;
        private HttpResponseStatus currentStatus;
        private String currentType;
        private String currentLocation;
        private String currentContent = "";

        public ClientHandler(BlockingQueue<SimpleHttpResponse> responses) {
            this.responses = responses;
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            LOG.debug("Received {}", (Object)msg);
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                this.currentStatus = response.getStatus();
                this.currentType = response.headers().get("Content-Type");
                this.currentLocation = response.headers().get("Location");
                if (HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                    LOG.debug("Content is chunked");
                }
            }
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                this.currentContent = this.currentContent + content.content().toString(CharsetUtil.UTF_8);
                if (content instanceof LastHttpContent) {
                    this.responses.add(new SimpleHttpResponse(this.currentStatus, this.currentType, this.currentContent, this.currentLocation));
                    this.currentStatus = null;
                    this.currentType = null;
                    this.currentLocation = null;
                    this.currentContent = "";
                    ctx.close();
                }
            }
        }
    }

    public static class SimpleHttpResponse {
        private final HttpResponseStatus status;
        private final String type;
        private final String content;
        private final String location;

        public SimpleHttpResponse(HttpResponseStatus status, String type, String content, String location) {
            this.status = status;
            this.type = type;
            this.content = content;
            this.location = location;
        }

        public HttpResponseStatus getStatus() {
            return this.status;
        }

        public String getType() {
            return this.type;
        }

        public final String getLocation() {
            return this.location;
        }

        public String getContent() {
            return this.content;
        }

        public String toString() {
            return "HttpResponse(status=" + this.status + ", type='" + this.type + "'" + ", content='" + this.content + "')";
        }
    }
}

