/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStats;
import org.apache.flink.runtime.checkpoint.stats.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.stats.JobCheckpointStats;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.JobCheckpointsHandler;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import scala.Option;

public class JobCheckpointsHandlerTest {
    @Test
    public void testNoCoordinator() throws Exception {
        JobCheckpointsHandler handler = new JobCheckpointsHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class));
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        Mockito.when((Object)graph.getCheckpointStatsTracker()).thenReturn(null);
        String response = handler.handleRequest(graph, Collections.emptyMap());
        Assert.assertEquals((Object)"{}", (Object)response);
    }

    @Test
    public void testNoStats() throws Exception {
        JobCheckpointsHandler handler = new JobCheckpointsHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class));
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        CheckpointStatsTracker tracker = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        Mockito.when((Object)graph.getCheckpointStatsTracker()).thenReturn((Object)tracker);
        Mockito.when((Object)tracker.getJobStats()).thenReturn((Object)Option.empty());
        String response = handler.handleRequest(graph, Collections.emptyMap());
        Assert.assertEquals((Object)"{}", (Object)response);
    }

    @Test
    public void testStats() throws Exception {
        JobCheckpointsHandler handler = new JobCheckpointsHandler((ExecutionGraphHolder)Mockito.mock(ExecutionGraphHolder.class));
        ExecutionGraph graph = (ExecutionGraph)Mockito.mock(ExecutionGraph.class);
        CheckpointStatsTracker tracker = (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class);
        Mockito.when((Object)graph.getCheckpointStatsTracker()).thenReturn((Object)tracker);
        final ArrayList<CheckpointStats> history = new ArrayList<CheckpointStats>();
        history.add(new CheckpointStats(0L, 1L, 1L, 124L));
        history.add(new CheckpointStats(1L, 5L, 177L, 0L));
        history.add(new CheckpointStats(2L, 6L, 8282L, 2L));
        history.add(new CheckpointStats(3L, 6812L, 2800L, 1024L));
        JobCheckpointStats stats = new JobCheckpointStats(){

            public List<CheckpointStats> getRecentHistory() {
                return history;
            }

            public long getCount() {
                return 4L;
            }

            public long getMinDuration() {
                return 1L;
            }

            public long getMaxDuration() {
                return 8282L;
            }

            public long getAverageDuration() {
                return 2815L;
            }

            public long getMinStateSize() {
                return 0L;
            }

            public long getMaxStateSize() {
                return 1024L;
            }

            public long getAverageStateSize() {
                return 287L;
            }
        };
        Mockito.when((Object)tracker.getJobStats()).thenReturn((Object)Option.apply((Object)stats));
        String response = handler.handleRequest(graph, Collections.emptyMap());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(response);
        int count = rootNode.get("count").asInt();
        Assert.assertEquals((long)stats.getCount(), (long)count);
        JsonNode durationNode = rootNode.get("duration");
        Assert.assertNotNull((Object)durationNode);
        long minDuration = durationNode.get("min").asLong();
        long maxDuration = durationNode.get("max").asLong();
        long avgDuration = durationNode.get("avg").asLong();
        Assert.assertEquals((long)stats.getMinDuration(), (long)minDuration);
        Assert.assertEquals((long)stats.getMaxDuration(), (long)maxDuration);
        Assert.assertEquals((long)stats.getAverageDuration(), (long)avgDuration);
        JsonNode sizeNode = rootNode.get("size");
        Assert.assertNotNull((Object)sizeNode);
        long minSize = sizeNode.get("min").asLong();
        long maxSize = sizeNode.get("max").asLong();
        long avgSize = sizeNode.get("avg").asLong();
        Assert.assertEquals((long)stats.getMinStateSize(), (long)minSize);
        Assert.assertEquals((long)stats.getMaxStateSize(), (long)maxSize);
        Assert.assertEquals((long)stats.getAverageStateSize(), (long)avgSize);
        JsonNode historyNode = rootNode.get("history");
        Assert.assertNotNull((Object)historyNode);
        Assert.assertTrue((boolean)historyNode.isArray());
        Iterator it = historyNode.elements();
        for (int i = 0; i < history.size(); ++i) {
            CheckpointStats s = (CheckpointStats)history.get(i);
            JsonNode node = (JsonNode)it.next();
            long checkpointId = node.get("id").asLong();
            long timestamp = node.get("timestamp").asLong();
            long duration = node.get("duration").asLong();
            long size = node.get("size").asLong();
            Assert.assertEquals((long)s.getCheckpointId(), (long)checkpointId);
            Assert.assertEquals((long)s.getTriggerTimestamp(), (long)timestamp);
            Assert.assertEquals((long)s.getDuration(), (long)duration);
            Assert.assertEquals((long)s.getStateSize(), (long)size);
        }
        Assert.assertFalse((boolean)it.hasNext());
    }
}

