/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.messages.JobManagerMessages;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.util.StringUtils;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class TaskManagersHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    private final FiniteDuration timeout;
    public static final String TASK_MANAGER_ID_KEY = "taskmanagerid";

    public TaskManagersHandler(FiniteDuration timeout) {
        this.timeout = Preconditions.checkNotNull(timeout);
    }

    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManager) throws Exception {
        try {
            if (jobManager != null) {
                ArrayList<Object> instances = new ArrayList<Object>();
                if (params.containsKey(TASK_MANAGER_ID_KEY)) {
                    try {
                        InstanceID instanceID = new InstanceID(StringUtils.hexStringToByte((String)params.get(TASK_MANAGER_ID_KEY)));
                        Future future = jobManager.ask((Object)new JobManagerMessages.RequestTaskManagerInstance(instanceID), this.timeout);
                        JobManagerMessages.TaskManagerInstance instance = (JobManagerMessages.TaskManagerInstance)Await.result((Awaitable)future, (Duration)this.timeout);
                        if (instance.instance().nonEmpty()) {
                            instances.add(instance.instance().get());
                        }
                    }
                    catch (IllegalArgumentException instanceID) {}
                } else {
                    Future future = jobManager.ask(JobManagerMessages.getRequestRegisteredTaskManagers(), this.timeout);
                    JobManagerMessages.RegisteredTaskManagers taskManagers = (JobManagerMessages.RegisteredTaskManagers)Await.result((Awaitable)future, (Duration)this.timeout);
                    instances.addAll(taskManagers.asJavaCollection());
                }
                StringWriter writer = new StringWriter();
                JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
                gen.writeStartObject();
                gen.writeArrayFieldStart("taskmanagers");
                for (Instance instance : instances) {
                    byte[] report;
                    gen.writeStartObject();
                    gen.writeStringField("id", instance.getId().toString());
                    gen.writeStringField("path", instance.getActorGateway().path());
                    gen.writeNumberField("dataPort", instance.getInstanceConnectionInfo().dataPort());
                    gen.writeNumberField("timeSinceLastHeartbeat", instance.getLastHeartBeat());
                    gen.writeNumberField("slotsNumber", instance.getTotalNumberOfSlots());
                    gen.writeNumberField("freeSlots", instance.getNumberOfAvailableSlots());
                    gen.writeNumberField("cpuCores", instance.getResources().getNumberOfCPUCores());
                    gen.writeNumberField("physicalMemory", instance.getResources().getSizeOfPhysicalMemory());
                    gen.writeNumberField("freeMemory", instance.getResources().getSizeOfJvmHeap());
                    gen.writeNumberField("managedMemory", instance.getResources().getSizeOfManagedMemory());
                    if (params.containsKey(TASK_MANAGER_ID_KEY) && (report = instance.getLastMetricsReport()) != null) {
                        gen.writeFieldName("metrics");
                        gen.writeRawValue(new String(report, "utf-8"));
                    }
                    gen.writeEndObject();
                }
                gen.writeEndArray();
                gen.writeEndObject();
                gen.close();
                return writer.toString();
            }
            throw new Exception("No connection to the leading JobManager.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch list of all task managers: " + e.getMessage(), e);
        }
    }
}

