/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractJobVertexRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class SubtasksTimesHandler
extends AbstractJobVertexRequestHandler
implements RequestHandler.JsonResponse {
    public SubtasksTimesHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionJobVertex jobVertex, Map<String, String> params) throws Exception {
        long now = System.currentTimeMillis();
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeStringField("id", jobVertex.getJobVertexId().toString());
        gen.writeStringField("name", jobVertex.getJobVertex().getName());
        gen.writeNumberField("now", now);
        gen.writeArrayFieldStart("subtasks");
        int num = 0;
        for (ExecutionVertex vertex : jobVertex.getTaskVertices()) {
            long[] timestamps = vertex.getCurrentExecutionAttempt().getStateTimestamps();
            ExecutionState status = vertex.getExecutionState();
            long scheduledTime = timestamps[ExecutionState.SCHEDULED.ordinal()];
            long start = scheduledTime > 0L ? scheduledTime : -1L;
            long end = status.isTerminal() ? timestamps[status.ordinal()] : now;
            long duration = start >= 0L ? end - start : -1L;
            gen.writeStartObject();
            gen.writeNumberField("subtask", num++);
            InstanceConnectionInfo location = vertex.getCurrentAssignedResourceLocation();
            String locationString = location == null ? "(unassigned)" : location.getHostname();
            gen.writeStringField("host", locationString);
            gen.writeNumberField("duration", duration);
            gen.writeObjectFieldStart("timestamps");
            for (ExecutionState state : ExecutionState.values()) {
                gen.writeNumberField(state.name(), timestamps[state.ordinal()]);
            }
            gen.writeEndObject();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

