/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;
import org.apache.flink.util.ExceptionUtils;

public class JobExceptionsHandler
extends AbstractExecutionGraphRequestHandler
implements RequestHandler.JsonResponse {
    private static final int MAX_NUMBER_EXCEPTION_TO_REPORT = 20;

    public JobExceptionsHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionGraph graph, Map<String, String> params) throws Exception {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        Throwable rootException = graph.getFailureCause();
        if (rootException != null) {
            gen.writeStringField("root-exception", ExceptionUtils.stringifyException((Throwable)rootException));
        }
        gen.writeArrayFieldStart("all-exceptions");
        int numExceptionsSoFar = 0;
        boolean truncated = false;
        for (ExecutionVertex task : graph.getAllExecutionVertices()) {
            Throwable t = task.getFailureCause();
            if (t == null) continue;
            if (numExceptionsSoFar >= 20) {
                truncated = true;
                break;
            }
            InstanceConnectionInfo location = task.getCurrentAssignedResourceLocation();
            String locationString = location != null ? location.getFQDNHostname() + ':' + location.dataPort() : "(unassigned)";
            gen.writeStartObject();
            gen.writeStringField("exception", ExceptionUtils.stringifyException((Throwable)t));
            gen.writeStringField("task", task.getSimpleName());
            gen.writeStringField("location", locationString);
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeBooleanField("truncated", truncated);
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

