/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.api.common.accumulators.LongCounter;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractExecutionGraphRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class JobDetailsHandler
extends AbstractExecutionGraphRequestHandler
implements RequestHandler.JsonResponse {
    public JobDetailsHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(ExecutionGraph graph, Map<String, String> params) throws Exception {
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        long now = System.currentTimeMillis();
        gen.writeStartObject();
        gen.writeStringField("jid", graph.getJobID().toString());
        gen.writeStringField("name", graph.getJobName());
        gen.writeStringField("state", graph.getState().name());
        long jobStartTime = graph.getStatusTimestamp(JobStatus.CREATED);
        long jobEndTime = graph.getState().isTerminalState() ? graph.getStatusTimestamp(graph.getState()) : -1L;
        gen.writeNumberField("start-time", jobStartTime);
        gen.writeNumberField("end-time", jobEndTime);
        gen.writeNumberField("duration", (jobEndTime > 0L ? jobEndTime : now) - jobStartTime);
        gen.writeNumberField("now", now);
        gen.writeObjectFieldStart("timestamps");
        for (JobStatus status : JobStatus.values()) {
            gen.writeNumberField(status.name(), graph.getStatusTimestamp(status));
        }
        gen.writeEndObject();
        int[] jobVerticesPerState = new int[ExecutionState.values().length];
        gen.writeArrayFieldStart("vertices");
        for (ExecutionJobVertex ejv : graph.getVerticesTopologically()) {
            long duration;
            int[] tasksPerState = new int[ExecutionState.values().length];
            long startTime = Long.MAX_VALUE;
            long endTime = 0L;
            boolean allFinished = true;
            for (ExecutionVertex vertex : ejv.getTaskVertices()) {
                ExecutionState state = vertex.getExecutionState();
                int n = state.ordinal();
                tasksPerState[n] = tasksPerState[n] + 1;
                long started = vertex.getStateTimestamp(ExecutionState.DEPLOYING);
                if (started > 0L) {
                    startTime = Math.min(startTime, started);
                }
                allFinished &= state.isTerminal();
                endTime = Math.max(endTime, vertex.getStateTimestamp(state));
            }
            if (startTime < Long.MAX_VALUE) {
                if (allFinished) {
                    duration = endTime - startTime;
                } else {
                    endTime = -1L;
                    duration = now - startTime;
                }
            } else {
                startTime = -1L;
                endTime = -1L;
                duration = -1L;
            }
            ExecutionState jobVertexState = ExecutionJobVertex.getAggregateJobVertexState((int[])tasksPerState, (int)ejv.getParallelism());
            int n = jobVertexState.ordinal();
            jobVerticesPerState[n] = jobVerticesPerState[n] + 1;
            Map metrics = ejv.getAggregatedMetricAccumulators();
            LongCounter readBytes = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_BYTES_IN);
            LongCounter writeBytes = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_BYTES_OUT);
            LongCounter readRecords = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_RECORDS_IN);
            LongCounter writeRecords = (LongCounter)metrics.get(AccumulatorRegistry.Metric.NUM_RECORDS_OUT);
            gen.writeStartObject();
            gen.writeStringField("id", ejv.getJobVertexId().toString());
            gen.writeStringField("name", ejv.getJobVertex().getName());
            gen.writeNumberField("parallelism", ejv.getParallelism());
            gen.writeStringField("status", jobVertexState.name());
            gen.writeNumberField("start-time", startTime);
            gen.writeNumberField("end-time", endTime);
            gen.writeNumberField("duration", duration);
            gen.writeObjectFieldStart("tasks");
            for (ExecutionState state : ExecutionState.values()) {
                gen.writeNumberField(state.name(), tasksPerState[state.ordinal()]);
            }
            gen.writeEndObject();
            gen.writeObjectFieldStart("metrics");
            gen.writeNumberField("read-bytes", readBytes != null ? readBytes.getLocalValuePrimitive() : -1L);
            gen.writeNumberField("write-bytes", writeBytes != null ? writeBytes.getLocalValuePrimitive() : -1L);
            gen.writeNumberField("read-records", readRecords != null ? readRecords.getLocalValuePrimitive() : -1L);
            gen.writeNumberField("write-records", writeRecords != null ? writeRecords.getLocalValuePrimitive() : -1L);
            gen.writeEndObject();
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeObjectFieldStart("status-counts");
        for (ExecutionState state : ExecutionState.values()) {
            gen.writeNumberField(state.name(), jobVerticesPerState[state.ordinal()]);
        }
        gen.writeEndObject();
        gen.writeFieldName("plan");
        gen.writeRawValue(graph.getJsonPlan());
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

