/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.messages.webmonitor.RequestJobDetails;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class CurrentJobsOverviewHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    private final FiniteDuration timeout;
    private final boolean includeRunningJobs;
    private final boolean includeFinishedJobs;

    public CurrentJobsOverviewHandler(FiniteDuration timeout, boolean includeRunningJobs, boolean includeFinishedJobs) {
        this.timeout = Preconditions.checkNotNull(timeout);
        this.includeRunningJobs = includeRunningJobs;
        this.includeFinishedJobs = includeFinishedJobs;
    }

    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManager) throws Exception {
        try {
            if (jobManager != null) {
                Future future = jobManager.ask((Object)new RequestJobDetails(this.includeRunningJobs, this.includeFinishedJobs), this.timeout);
                MultipleJobsDetails result = (MultipleJobsDetails)Await.result((Awaitable)future, (Duration)this.timeout);
                long now = System.currentTimeMillis();
                StringWriter writer = new StringWriter();
                JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
                gen.writeStartObject();
                if (this.includeRunningJobs && this.includeFinishedJobs) {
                    gen.writeArrayFieldStart("running");
                    for (JobDetails detail : result.getRunningJobs()) {
                        CurrentJobsOverviewHandler.generateSingleJobDetails(detail, gen, now);
                    }
                    gen.writeEndArray();
                    gen.writeArrayFieldStart("finished");
                    for (JobDetails detail : result.getFinishedJobs()) {
                        CurrentJobsOverviewHandler.generateSingleJobDetails(detail, gen, now);
                    }
                    gen.writeEndArray();
                } else {
                    gen.writeArrayFieldStart("jobs");
                    for (JobDetails detail : this.includeRunningJobs ? result.getRunningJobs() : result.getFinishedJobs()) {
                        CurrentJobsOverviewHandler.generateSingleJobDetails(detail, gen, now);
                    }
                    gen.writeEndArray();
                }
                gen.writeEndObject();
                gen.close();
                return writer.toString();
            }
            throw new Exception("No connection to the leading JobManager.");
        }
        catch (Exception e) {
            throw new Exception("Failed to fetch the status overview: " + e.getMessage(), e);
        }
    }

    private static void generateSingleJobDetails(JobDetails details, JsonGenerator gen, long now) throws Exception {
        gen.writeStartObject();
        gen.writeStringField("jid", details.getJobId().toString());
        gen.writeStringField("name", details.getJobName());
        gen.writeStringField("state", details.getStatus().name());
        gen.writeNumberField("start-time", details.getStartTime());
        gen.writeNumberField("end-time", details.getEndTime());
        gen.writeNumberField("duration", (details.getEndTime() <= 0L ? now : details.getEndTime()) - details.getStartTime());
        gen.writeNumberField("last-modification", details.getLastUpdateTime());
        gen.writeObjectFieldStart("tasks");
        gen.writeNumberField("total", details.getNumTasks());
        int[] perState = details.getNumVerticesPerExecutionState();
        gen.writeNumberField("pending", perState[ExecutionState.CREATED.ordinal()] + perState[ExecutionState.SCHEDULED.ordinal()] + perState[ExecutionState.DEPLOYING.ordinal()]);
        gen.writeNumberField("running", perState[ExecutionState.RUNNING.ordinal()]);
        gen.writeNumberField("finished", perState[ExecutionState.FINISHED.ordinal()]);
        gen.writeNumberField("canceling", perState[ExecutionState.CANCELING.ordinal()]);
        gen.writeNumberField("canceled", perState[ExecutionState.CANCELED.ordinal()]);
        gen.writeNumberField("failed", perState[ExecutionState.FAILED.ordinal()]);
        gen.writeEndObject();
        gen.writeEndObject();
    }
}

