/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.webmonitor.JobsWithIDsOverview;
import org.apache.flink.runtime.messages.webmonitor.RequestJobsWithIDsOverview;
import org.apache.flink.runtime.webmonitor.JobManagerRetriever;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class CurrentJobIdsHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    private final JobManagerRetriever retriever;
    private final FiniteDuration timeout;

    public CurrentJobIdsHandler(JobManagerRetriever retriever, FiniteDuration timeout) {
        if (retriever == null || timeout == null) {
            throw new NullPointerException();
        }
        this.retriever = retriever;
        this.timeout = timeout;
    }

    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManager) throws Exception {
        try {
            if (jobManager != null) {
                Future future = jobManager.ask((Object)RequestJobsWithIDsOverview.getInstance(), this.timeout);
                JobsWithIDsOverview overview = (JobsWithIDsOverview)Await.result((Awaitable)future, (Duration)this.timeout);
                StringWriter writer = new StringWriter();
                JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
                gen.writeStartObject();
                gen.writeArrayFieldStart("jobs-running");
                for (JobID jid : overview.getJobsRunningOrPending()) {
                    gen.writeString(jid.toString());
                }
                gen.writeEndArray();
                gen.writeArrayFieldStart("jobs-finished");
                for (JobID jid : overview.getJobsFinished()) {
                    gen.writeString(jid.toString());
                }
                gen.writeEndArray();
                gen.writeArrayFieldStart("jobs-cancelled");
                for (JobID jid : overview.getJobsCancelled()) {
                    gen.writeString(jid.toString());
                }
                gen.writeEndArray();
                gen.writeArrayFieldStart("jobs-failed");
                for (JobID jid : overview.getJobsFailed()) {
                    gen.writeString(jid.toString());
                }
                gen.writeEndArray();
                gen.writeEndObject();
                gen.close();
                return writer.toString();
            }
            throw new Exception("No connection to the leading JobManager.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch list of all running jobs: " + e.getMessage(), e);
        }
    }
}

