/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.messages.webmonitor.RequestStatusOverview;
import org.apache.flink.runtime.messages.webmonitor.StatusOverview;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ClusterOverviewHandler
implements RequestHandler,
RequestHandler.JsonResponse {
    private final FiniteDuration timeout;

    public ClusterOverviewHandler(FiniteDuration timeout) {
        this.timeout = Preconditions.checkNotNull(timeout);
    }

    @Override
    public String handleRequest(Map<String, String> params, ActorGateway jobManager) throws Exception {
        try {
            if (jobManager != null) {
                Future future = jobManager.ask((Object)RequestStatusOverview.getInstance(), this.timeout);
                StatusOverview overview = (StatusOverview)Await.result((Awaitable)future, (Duration)this.timeout);
                StringWriter writer = new StringWriter();
                JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
                gen.writeStartObject();
                gen.writeNumberField("taskmanagers", overview.getNumTaskManagersConnected());
                gen.writeNumberField("slots-total", overview.getNumSlotsTotal());
                gen.writeNumberField("slots-available", overview.getNumSlotsAvailable());
                gen.writeNumberField("jobs-running", overview.getNumJobsRunningOrPending());
                gen.writeNumberField("jobs-finished", overview.getNumJobsFinished());
                gen.writeNumberField("jobs-cancelled", overview.getNumJobsCancelled());
                gen.writeNumberField("jobs-failed", overview.getNumJobsFailed());
                gen.writeEndObject();
                gen.close();
                return writer.toString();
            }
            throw new Exception("No connection to the leading JobManager.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch list of all running jobs: " + e.getMessage(), e);
        }
    }
}

