/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.instance.ActorGateway;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.NotFoundException;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public abstract class AbstractExecutionGraphRequestHandler
implements RequestHandler {
    private final ExecutionGraphHolder executionGraphHolder;

    public AbstractExecutionGraphRequestHandler(ExecutionGraphHolder executionGraphHolder) {
        this.executionGraphHolder = executionGraphHolder;
    }

    @Override
    public final String handleRequest(Map<String, String> params, ActorGateway jobManager) throws Exception {
        JobID jid;
        String jidString = params.get("jobid");
        if (jidString == null) {
            throw new RuntimeException("JobId parameter missing");
        }
        try {
            jid = JobID.fromHexString((String)jidString);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid JobID string '" + jidString + "': " + e.getMessage());
        }
        ExecutionGraph eg = this.executionGraphHolder.getExecutionGraph(jid, jobManager);
        if (eg == null) {
            throw new NotFoundException("Could not find job with id " + jid);
        }
        return this.handleRequest(eg, params);
    }

    public abstract String handleRequest(ExecutionGraph var1, Map<String, String> var2) throws Exception;
}

