/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.handlers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.webmonitor.ExecutionGraphHolder;
import org.apache.flink.runtime.webmonitor.handlers.AbstractSubtaskAttemptRequestHandler;
import org.apache.flink.runtime.webmonitor.handlers.JsonFactory;
import org.apache.flink.runtime.webmonitor.handlers.RequestHandler;

public class SubtaskExecutionAttemptAccumulatorsHandler
extends AbstractSubtaskAttemptRequestHandler
implements RequestHandler.JsonResponse {
    public SubtaskExecutionAttemptAccumulatorsHandler(ExecutionGraphHolder executionGraphHolder) {
        super(executionGraphHolder);
    }

    @Override
    public String handleRequest(Execution execAttempt, Map<String, String> params) throws Exception {
        StringifiedAccumulatorResult[] accs = execAttempt.getUserAccumulatorsStringified();
        StringWriter writer = new StringWriter();
        JsonGenerator gen = JsonFactory.jacksonFactory.createJsonGenerator((Writer)writer);
        gen.writeStartObject();
        gen.writeNumberField("subtask", execAttempt.getVertex().getSubTaskIndex());
        gen.writeNumberField("attempt", execAttempt.getAttemptNumber());
        gen.writeStringField("id", execAttempt.getAttemptId().toShortString());
        gen.writeArrayFieldStart("user-accumulators");
        for (StringifiedAccumulatorResult acc : accs) {
            gen.writeStartObject();
            gen.writeStringField("name", acc.getName());
            gen.writeStringField("type", acc.getType());
            gen.writeStringField("value", acc.getValue());
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeEndObject();
        gen.close();
        return writer.toString();
    }
}

